<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
	<meta name="MSSmartTagsPreventParsing" content="TRUE" />
	<?php dcHeadLinks(); ?>
	<link rel="alternate" type="application/rss+xml" title="RSS" href="<?php dcInfo('rss'); ?>" />
	<meta name="DC.title" content="<?php dcInfo(); ?>" />
	<title><?php dcSinglePostTitle('%s - '); dcSingleCatTitle('%s - ');
	dcSingleMonthTitle('%s - '); dcInfo(); ?></title>
	
	<link rel="stylesheet" type="text/css" href="<?php dcInfo('theme'); ?>/style.css" media="screen" />
	<?php dcPostTrackbackAutoDiscovery(); ?>
</head>

<body>

<p id="prelude">
	<a href="#main">Aller au contenu</a> |
	<a href="#menu">Aller au menu</a> |
	<a href="#recherche">Aller  la recherche</a>
</p>

<h1 id="top"><a href="<?php dcInfo('url'); ?>"><?php dcInfo(); ?></a></h1>

<div id="page">

<div id="main">
	<div id="content">
	<?php # Si on a une quelconque erreur, on affiche l'erreur
	if ($err_msg != '')
	{ ?>
     	<div class="erreur"><strong>Erreur : </strong>
		<?php echo $err_msg; ?></div>
    
	<?php # Si aucune erreur et mode != post on affiche une liste de billets
	}
	elseif ($mode != 'post')
	{ ?>
		
		<?php # Phrase affich en cas de recherche (%s est le mot cherch)
		dcSearchString('<p>Rsultats de votre recherche de <em>%s</em>.</p>');
		?>
		
		<?php # Boucle sur la liste de billets
		while (!$news->EOF())
		{ ?>
			<?php dcDayDate('<p class="day-date">%s</p>'); ?>
			
			<h2 id="p<?php dcPostID(); ?>"><?php dcPostTitle(); ?></h2>
			<div class="billet"><?php dcPostAbstract('%s'); ?></div>
			
			<p class="post-info">Par <?php dcPostAuthor(); ?>,
			 <?php dcPostTime(); ?>
			:: <a href="<?php dcPostCatURL(); ?>"><?php dcPostCatTitle(); ?></a>
			:: <a href="<?php dcPostURL(); ?>"
			title="Lien permanent vers : <?php dcPostTitle(); ?>">#<?php dcPostID(); ?></a>
			:: <a href="<?php dcPostURL(); ?>#co"><?php
			dcPostNbComments('aucun commentaire','un commentaire','%s commentaires');
			?></a></p>
		
		<?php # Fin de la boucle
		$news->moveNext();
		} ?>
		
	<?php # Sinon, mode = post, donc billet unique (avec commentaires et tout le reste)
	}
	else
	{ ?>
		
		<h2><?php dcPostTitle(); ?></h2>
		
		<?php dcPostChapo('<div class="chapo">%s</div>'); ?>
		<div class="billet"><?php dcPostContent(); ?></div>
		
		<p class="post-info">Par <?php dcPostAuthor(); ?>
		:: <?php dcPostDate(); ?>  <?php dcPostTime(); ?>
		:: <a href="<?php dcPostCatURL(); ?>"><?php dcPostCatTitle(); ?></a>
		:: <a href="<?php dcPostURL(); ?>"
		title="Lien permanent vers : <?php dcPostTitle(); ?>">#<?php dcPostID(); ?></a>
		:: <a href="<?php dcInfo('rss'); ?>?type=co&amp;post=<?php dcPostID(); ?>"
		title="Fil RSS des commentaires de ce billet">rss</a></p>
		
		<div id="co">
		<h3>Vos commentaires</h3>
		
		<?php # Si pas de commentaires, on met un message sympathique
		if ($comments->isEmpty()) { ?>
			<p>Aucun commentaire pour le moment.</p>
		<?php } ?>
		
		<?php # Boucle de commentaires
		while (!$comments->EOF())
		{ ?>
			
			<div id="c<?php dcCommentID(); ?>">
			<?php # Si le commentaire n'est pas un trackback
			if(!dcCommentIsTrackBack())
			{ ?>
				
				<p class="comment-info">Le <?php dcCommentDate(); ?> 
				<?php dcCommentTime(); ?>, commentaire par
				<strong><?php dcCommentAuthor(); ?></strong>
				<?php dcCommentAuthorLink(':: <a href="mailto:%s">email</a>'); ?>
				<?php dcCommentAuthorSite(':: <a href="%s">site</a>'); ?>
				:: <a href="#c<?php dcCommentID(); ?>">#</a></p>
				
			<?php # Sinon, si le commentaire est un trackback
			}
			else
			{ ?>
				<p class="comment-info">Le <?php dcCommentDate(); ?> 
				<?php dcCommentTime(); ?>, trackback de
				<strong><?php dcCommentAuthor(); ?></strong>
				:: <a href="#c<?php dcCommentID(); ?>">#</a></p>
			<?php
			} ?>
			
			<?php /* on affiche le commentaire */ ?>
			<blockquote>
			<?php dcCommentContentTransform(); ?>
			</blockquote>
			</div>
			
		<?php # Fin de la boucle de commentaires
		$comments->moveNext();
		} ?>
		
		<h3>Ajouter un commentaire</h3>
		<?php # Si les commentaires sont permis
		if (dcPostOpenComments() && ($cf_allow_comments || $cf_allow_trackbacks))
		{ ?>
			<?php # Si les commentaires sont permis
			if ($cf_allow_comments)
			{ ?>
				<form action="<?php dcPostUrl(); ?>" method="post" class="form">
				<fieldset>
					<?php dcCommentFormError('<div class="erreur"><strong>Erreurs :</strong><br /> %s</div>'); ?>
					<p class="field"><label for="c_nom">Nom ou pseudo&nbsp;:</label>
					<input name="c_nom" id="c_nom" type="text" size="30" maxlength="255"
					value="<?php dcCommentFormValue('c_nom'); ?>" />
					</p>
				
					<p class="field"><label for="c_mail">Email (facultatif)&nbsp;:</label>
					<input name="c_mail" id="c_mail" type="text" size="30" maxlength="255"
					value="<?php dcCommentFormValue('c_mail'); ?>" />
					</p>
				
					<p class="field"><label for="c_site">Site Web (facultatif)&nbsp;:</label>
					<input name="c_site" id="c_site" type="text" size="30" maxlength="255"
					value="<?php dcCommentFormValue('c_site'); ?>" />
					</p>
					
					<p class="field"><label for="c_content">Commentaire&nbsp;:</label>
					<textarea name="c_content" id="c_content" cols="35" rows="7"><?php
					dcCommentFormValue('c_content');
					?></textarea>
					</p>
				</fieldset>
				
				<p>Le code HTML dans le commentaire sera affich comme du texte,
				les adresses internet seront converties automatiquement.</p>
				
				<fieldset>	
					<p class="field"><input type="submit" value="envoyer" />
					<input type="hidden" name="redir" value="<?php dcCommentFormRedir(); ?>" /></p>
				</fieldset>
				
				</form>
			<?php
			} ?>
			
			<?php # Si les trackbacks sont permis
			if ($cf_allow_trackbacks)
			{ ?>
				<p>Pour faire un tracback sur ce billet&nbsp;:
				<?php echo dcPostTrackBackURI(); ?></p>
			<?php
			} ?>
			
		<?php
		}
		else
		{ ?>
			<p>Les commentaires pour ce billet sont ferms.</p>
		<?php
		} ?>
		</div>
		
	<?php
	} ?>
	
	<hr class="invisible"/>
	</div>
</div>

<div id="menu">
	<div class="col-content">
	<?php #Affichage du calendrier
	dcCalendar(); ?>
	
	<h2 id="recherche">Rechercher</h2>
	<form action="<?php dcInfo('search'); ?>" method="get" class="search">
	<fieldset>
		<p class="field"><input name="q" id="q" type="text" size="10"
		value="<?php dcSearchString(); ?>" />
		<input type="submit" value="ok" /></p>
	</fieldset>
	</form>
	
	<h2>Catgories</h2>
	<?php dcCatList(); ?>
	
	<h2>Archives</h2>
	<?php dcMonthsList(); ?>
	
	<h2>Liens</h2>
	<ul>
		<li><a href="#">Lien #1</a></li>
		<li><a href="#">Lien #2</a></li>
	</ul>
	
	<ul>
		<li><a href="<?php dcInfo('rss'); ?>">fil rss</a></li>
		<li><a href="<?php dcInfo('rss'); ?>?type=co">fil rss (commentaires)</a></li>
	</ul>
	</div>
</div>

</div>

<div id="footer">
	<p><a href="http://www.dotclear.net/"><img
	src="<?php dcInfo('img'); ?>dotclear_pw.png"
	alt="propuls par DotClear" /></a>
	</p>
</div>

</body>
</html>