<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

# Chemin vers la racine de l'application (si vous changer le fichier de place)
$app_path = '/';

require dirname(__FILE__).$app_path.'conf/config.php';
require dirname(__FILE__).$app_path.'inc/prepend.php';


# Si on est l, alors on a un _POST
# Connexion et cration du blog
header('Content-Type: text/xml');
echo '<?xml version="1.0" encoding="iso-8859-1"?>'."\n";
echo '<response>'."\n";

$content = '';

if (empty($_GET['id']))
{
	$content = '<error>1</error>'."\n".
	'<message>No ID.</message>';
}
else
{
	$id = $_GET['id'];
	
	$con = new Connection($dbuser,$dbpass,$dbhost,$dbbase);
	
	if($con->error())
	{
		$content = '<error>1</error>'."\n".
		'<message>MySQL connection error : '.$con->error().'</message>';
	}
	else
	{
		$blog = new blog($con,$dbprefix,1);
		
		$blog->setURL('post',$cf_blog_url.$cf_format_post_url);
		
		$post = $blog->getPostByID($id);
		
		if ($post->isEmpty())
		{
			$content = '<error>1</error>'."\n".
			'<message>No post for this ID.</message>';
		}
		elseif (!$cf_allow_trackbacks || !$post->f('post_open_comment'))
		{
			$content = '<error>1</error>'."\n".
			'<message>Trackbacks are not allowed for this post or weblog.</message>';
		}
		elseif (!empty($_GET['__mode']) && $_GET['__mode'] == 'rss')
		{
			$tb_url = 'http://'.$_SERVER['HTTP_HOST'].sprintf($cf_trackback_uri,$id);
			
			if ($post->f('post_chapo') != '') {
				$post_excerpt = $post->f('post_chapo');
			} else {
				$post_excerpt = $post->f('post_content');
			}
			$post_excerpt = substr(strip_tags($post_excerpt),0,255);
			
			$content = '<error>0</error>'."\n".
			'<rss version="0.91"><channel>'."\n".
			'<title>'.$cf_blog_name.' - Trackback</title>'."\n".
			'<link>'.$tb_url.'</link>'."\n".
			'<description>TrackBack item for this blog</description>'."\n".
			'<language>fr</language>'."\n".
			'<item>'."\n".
			'<title>'.$blog->toXML($post->f('post_titre'),0).'</title>'."\n".
			'<link>http://'.$_SERVER['HTTP_HOST'].$post->getPermURL().'</link>'."\n".
			'<description>'.$post_excerpt.'</description>'."\n".
			'</item>'."\n".
			'</channel>'."\n".
			'</rss>';
		}
		elseif (empty($_POST['url']))
		{
			$content = '<error>1</error>'."\n".
			'<message>URL parameter is requiered.</message>';
		}
		else
		{
			$url = $_POST['url'];
			$title = (!empty($_POST['title'])) ? $_POST['title'] : $url;
			$excerpt = (!empty($_POST['excerpt'])) ? $_POST['excerpt'] : '';
			$blog_name = (!empty($_POST['blog_name'])) ? $_POST['blog_name'] : '';
			
			if (trim($title) == '') {
				$title = $url;
			}
			
			if (strlen($excerpt) > 255) {
				$excerpt = substr($excerpt,0,252).'...';
			}
			
			$comment = '<!-- TB -->'."\n".
					'<p><strong>'.$title.'</strong></p>'."\n".
					'<p>'.$excerpt.'</p>';
			
			if ($blog->addComment($id,$blog_name,'',$url,$comment,true) !== false) {
				$content = '<error>0</error>';
			} else {
				$err = $blog->error(0);
				$content = '<error>1</error>'."\n".
				'<message>'.$err[0][1].'</message>';
			}
		}
		
		$con->close();
	}
}

echo $content."\n";
echo '</response>';
?>