<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/conf/config.php';

require dirname(__FILE__).'/inc/class.mysql.php';
require dirname(__FILE__).'/inc/class.blog.php';
require dirname(__FILE__).'/layout/class.xblog.php';
require dirname(__FILE__).'/layout/class.xblogpost.php';
require dirname(__FILE__).'/layout/class.xblogcomment.php';

$type = (!empty($_GET['type']) && $_GET['type'] == 'co') ? 'co' : 'blog';

# Connexion MySQL
$con = new Connection($dbuser,$dbpass,$dbhost,$dbbase);

# Cration de l'objet de type weblog avec uniquement les billets
# publis
$blog = new xblog($con,$dbprefix,1);
$blog->rs_blogpost = 'xblogpost';
$blog->rs_blogcomment = 'xblogcomment';

$blog->setURL('post','http://'.$_SERVER['SERVER_NAME'].$cf_blog_url.$cf_format_post_url);

# Si type = co on fait un fil des commentaires
if ($type == 'co')
{
	if (!empty($_GET['post'])) {
		$comments = $blog->getComments($_GET['post'],'DESC');
	} else {
		$comments = $blog->getComments('','DESC',20);
	}
	
	$title = $cf_blog_name.' - Commentaires';
	$ts = time();
	$items = $seq = '';
	
	if (!$comments->isEmpty())
	{
		$ts = $comments->getTS();
		
		while(!$comments->EOF())
		{
			$seq .= $comments->getRSSSeq();
			$items .= $comments->getRSSItem();
			
			$comments->moveNext();
		}
	}
}
else
{
	# Dernires nouvelles
	$news = $blog->getLastNews(10,'','DESC');
	
	$ts = strtotime($blog->getEarlierDate());
	$title = $cf_blog_name;
	
	$items = $seq = '';
	while(!$news->EOF())
	{
		$items .= $news->getRSSItem();
		$seq .= $news->getRSSSeq();
		
		$news->moveNext();
	}
}

# Fermeture de connexion
$con->close();
if (file_exists(dirname(__FILE__).'/themes/'.$cf_theme.'/rss.css')) {
	$rss_css = 'themes/'.$cf_theme.'/rss.css';
} else {
	$rss_css = 'themes/default/rss.css';
}

header('Content-Type: text/xml');
echo '<?xml version="1.0" encoding="UTF-8" ?>'."\n";
echo '<?xml-stylesheet href="'.$rss_css.'" type="text/css"?>'."\n";
?>
<rdf:RDF
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
  xmlns:admin="http://webns.net/mvcb/"
  xmlns:cc="http://web.resource.org/cc/"
  xmlns="http://purl.org/rss/1.0/">

<channel rdf:about="<?php echo 'http://'.$_SERVER['SERVER_NAME'].$cf_blog_url; ?>">
  <title><?php echo $blog->toXML($title); ?></title>
  <description></description>
  <link><?php echo 'http://'.$_SERVER['SERVER_NAME'].$cf_blog_url; ?></link>
  <dc:language>fr-fr</dc:language>
  <dc:creator></dc:creator>
  <dc:rights></dc:rights>
  <dc:date><?php echo date('Y-m-d\\TH:i:s+00:00',$ts); ?></dc:date>
  <admin:generatorAgent rdf:resource="http://www.dotclear.net/" />
  
  
  <items>
  <rdf:Seq>
  <?php echo $seq; ?>
  </rdf:Seq>
  </items>
</channel>

<?php echo $items; ?>

</rdf:RDF>