<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../conf/config.php';

$dotclear_uri = preg_replace('|[^/]+/$|','',$cf_blog_url).$app_path;
$dotclear_uri = preg_replace('|[/]+|','/',$dotclear_uri);

require dirname(__FILE__).'/../inc/prepend.php';
require dirname(__FILE__).'/../inc/lib.mod.php';

require dirname(__FILE__).'/class.xblog.php';
require dirname(__FILE__).'/class.xblogpost.php';
require dirname(__FILE__).'/class.xblogcomment.php';
require dirname(__FILE__).'/functions.php';

# Dfinition du mode
$blog_mod = dc_get_mod($cf_blog_url);

$mode = $blog_mod['mode'];
$year = $blog_mod['year'];
$month = $blog_mod['month'];
$day = $blog_mod['day'];
$post_id = $blog_mod['post_id'];
$cat_id = $blog_mod['cat_id'];

$err_msg = '';
$form_err = '';

# Tableau des dates de modif
$arry_last_mod = array();

# Variables pour le formulaire
$c_nom = $c_mail = $c_content = '';
$c_site = 'http://';

# Variable de conf
$theme_path = $blog_dc_path.'themes/';
$theme_uri = $dotclear_uri.'themes/';
$img_path = $cf_img_url;

# Dfinition du template
if (!is_dir($theme_path.$cf_theme)) {
	header('Content-type: text/plain');
	echo 'Le thme '.$cf_theme.' n\'existe pas';
	exit;
}

if (file_exists($theme_path.$cf_theme.'/template.php')) {
	$dc_template_file = $theme_path.$cf_theme.'/template.php';
} else {
	$dc_template_file = $blog_dc_path.'/template.php';
}

# Prepend du template s'il existe
if (file_exists($theme_path.$cf_theme.'/prepend.php')) {
	require $theme_path.$cf_theme.'/prepend.php';
}

/* Cration du tableau des dates de modification de tous les fichiers
inclus. On ajoute aussi le fichier UPDATE, append.php et le template
*/
array_walk(
	get_included_files(),
	create_function('&$v','global $arry_last_mod; $arry_last_mod[] = filemtime($v);')
);

if (defined('DC_UPDATE_FILE_W') && DC_UPDATE_FILE_W) {
	$arry_last_mod[] = $cf_lastupddt;
}

$arry_last_mod[] = filemtime($dc_template_file);
$arry_last_mod[] = filemtime($blog_dc_path.'layout/append.php');


# Cache HTTP
if ($cf_http_cache && $mode != 'search' && defined('DC_UPDATE_FILE_W') && DC_UPDATE_FILE_W)
{
	rsort($arry_last_mod);
	$last_mod_dt = $arry_last_mod[0];
	header('Date: '.gmdate('D, d M Y H:i:s').' GMT');
	header('Last-Modified: '.gmdate('D, d M Y H:i:s',$last_mod_dt).' GMT');
	header('Cache-Control: must-revalidate, max-age=0');
	header('Pragma: public');
	
	if (!empty($_SERVER['HTTP_IF_MODIFIED_SINCE']))
	{
		$since = strtotime(substr($_SERVER['HTTP_IF_MODIFIED_SINCE'],0,29));
		if ($since >= $last_mod_dt) {
			if (version_compare(phpversion(),'4.3.0','>=')) {
				header('Not Modified', TRUE, 304);
				exit;
			} else {
				header('Status: 304 Not Modified');
				exit;
			}
		}
	}
}


# Connexion et cration du blog
$con = new Connection($dbuser,$dbpass,$dbhost,$dbbase);

if($con->error()) {
	header('Content-Type: text/plain');
	echo 'Erreur MySQL : '.$con->error();
	exit;
}

$blog = new xblog($con,$dbprefix,1);
$blog->rs_blogpost = 'xblogpost';
$blog->rs_blogcomment = 'xblogcomment';

$blog->setURL('post',$cf_blog_url.$cf_format_post_url);
$blog->setURL('cat',$cf_blog_url.$cf_format_cat_url);
$blog->setURL('archive',$cf_blog_url.$cf_format_archive_url);
$blog->setURL('day',$cf_blog_url.$cf_format_day_url);

$blog->setDateFormat($cf_date_format,$cf_time_format);

$blog->setUseSmilies($cf_use_smilies);

if (is_dir($theme_path.$cf_theme.'/smilies/')) {
	$blog->setSmiliesPath($theme_uri.$cf_theme.'/smilies/');
} else {
	$blog->setSmiliesPath($theme_uri.'default/smilies/');
}

$head_links = array();

# Catgories
$rs_cat = $blog->getCat();

# Mois pour les archives
$arry_months = $blog->getAllDates('m','','','',$cat_id);

if (!empty($_GET['q'])) {
	$mode = 'search';
}

if($mode == 'home' || $mode == 'cat' && $cat_id || $mode == 'year')
{
	# Dernires nouvelles
	$news = $blog->getLastNews($cf_nb_post_per_page,$cat_id,'DESC');
	
	if ($news->isEmpty()) {
		$err_msg = '<p>Aucun billet.</p>';
	}
		
	$head_links .= $news->getHeadLinks();
}
elseif($mode == 'day')
{
	$news = $blog->getPostByDate($year,$month,$day,$cat_id,'DESC');
	
	if ($news->isEmpty()) {
		$err_msg = '<p>Aucun billet.</p>';
	}
}
elseif($mode == 'month')
{
	$news = $blog->getPostByDate($year,$month,'',$cat_id,'DESC');
	
	if ($news->isEmpty()) {
		$err_msg = '<p>Aucun billet.</p>';
	}
}
elseif($mode == 'post' && $post_id)
{
	$news = $blog->getPostByID($post_id);
	
	if ($news->isEmpty()) {
		$err_msg = '<p>Aucun billet.</p>';
	} else {
		# Ajout d'un commentaire
		if (!empty($_POST['redir']) && $news->f('post_open_comment') && $cf_allow_comments) {
			$c_nom = trim($_POST['c_nom']);
			$c_mail = trim($_POST['c_mail']);
			$c_site = trim($_POST['c_site']);
			
			if (trim($_POST['c_content']) == '') {
				$in_content = $c_content = '';
			} else {
				$c_content = $_POST['c_content'];
				
				if ($cf_wiki_comments)
				{
					$objWiki = new wiki2xhtml();
					$in_content = $objWiki->transform($c_content);
				}
				else
				{
					$in_content = '<p>'.
					nl2br($blog->parseContent(htmlspecialchars($c_content))).'</p>';
				}
			}
			
			if ($blog->addComment($post_id,$c_nom,$c_mail,$c_site,$in_content) === false)
			{
				$form_err = $blog->error(1,0);
			}
			else
			{
				if ($cf_comment_notification && $news->f('user_email') != '')
				{
					$n_titre = $blog->removeEntities($news->f('post_titre'));
					$n_mail = $news->f('user_email');
					$n_subject = '['.$cf_blog_name.'] '.$n_titre;
					
					$n_content =
							'Commentaire pour le billet : '.$n_titre."\n\n".
							'Par  : '.$c_nom.(($c_mail!='') ? ' <'.$c_mail.'>' : '')."\n".
							'Site : '.$c_site."\n".
							"\n".str_replace("\r",'',$c_content)."\n\n".
							"--\n".
							'http://'.$_SERVER['SERVER_NAME'].$news->getPermURL();
					
					$n_headers =
							'From: '.$n_mail."\r\n".
							(($c_mail!='') ? 'Reply-To: '.$c_mail."\r\n" : '').
							'X-Mailer: DotClear';
					
					@mail($n_mail,$n_subject,$n_content,$n_headers);
				}
				
				header('Location: '.$_POST['redir']);
				exit;
			}
		}
		
		$comments = $blog->getComments($post_id);
		
		$rs_prev = $blog->getNextID($news->getTS(),-1);
		$rs_next = $blog->getNextID($news->getTS(),1);
	}
}
elseif($mode == 'search')
{
	# Rsultat de recherche
	$news = $blog->searchPost($_GET['q']);
	
	if ($news->isEmpty()) {
		$err_msg = '<p>La recherche de <em>'.$_GET['q'].'</em> ne donne aucun rsultat.</p>';
	}
}

# Envoie des en-tte HTTP
if ($cf_send_real_xml && !empty($_SERVER['HTTP_ACCEPT']) 
&& strpos($_SERVER['HTTP_ACCEPT'],'application/xhtml+xml') !== false) {
	header('Content-Type: application/xhtml+xml');
	echo '<?xml version="1.0" encoding="ISO-8859-1"?>'."\n";
} else {
	header('Content-Type: text/html; charset=ISO-8859-1');
}

?>