<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
# Nicky Duong
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

/**
@proto doc

!!!Fonctionnement des gabarits

!!Introduction

Le systme de modle de page de DotClear n'est pas ce qui se fait de plus
simple  l'usage mais reste abordable pour peu de bien lire la
documentation.

Le fonctionnement est trs simple, il s'agit de fonctions PHP qui se
chargent d'afficher l'information qu'on lui demande.

Parfois un motif est utilis pour formater l'information affiche. Ce motif
constitue une marque de substitution, gnralement identifie par %s. Pour de
plus amples dtails, suivrent la documentation de la fonction
??PHP|PHP Hypertext Processor??,
[sprintf|http://fr2.php.net/manual/fr/function.sprintf.php].
Pour chaque fonction utilisant un motif, nous expliquerons comment le remplir.
*/

/**
@proto doc

!! Les fonctions informatives

Les fonctions suivantes permettent d'afficher des renseignements divers sur
le blog ou les billets.
*/


/**
Fonction affichant une information sur le blog.
La proprit __name__ peut prendre les valeurs suivantes :

* css : chemin vers le rpertoire contenant les feuilles de style
* img : chemin vers les images
* url : URL de la home page du blog
* rss : chemin vers le fil RSS
* search : chemin de l'action pour le moteur de rechercher

Exemple :

|<h1><?php dcInfo(); ?></h1>
|
|<a href="<?php dcInfo('rss'); ?>">fil rss</a>

@proto 	function  	 dcInfo

@param 	string name 	Nom de la proprit  afficher 	('name')
*/
function dcInfo($name='name')
{
	switch ($name)
	{
		case 'theme' : echo $GLOBALS['theme_uri'].$GLOBALS['cf_theme']; break;
		case 'img' : echo $GLOBALS['img_path']; break;
		case 'url' : echo $GLOBALS['cf_blog_url']; break;
		case 'rss' : echo $GLOBALS['cf_blog_rss']; break;
		case 'search' : echo $GLOBALS['cf_blog_url']; break;
		default : echo htmlentities($GLOBALS['cf_blog_name'],ENT_COMPAT);
	}
}

/**
Cette fonction affiche la date du jour. Elle est utilise dans la boucle
des billets et n'affiche la date que lors du premier billet du jour. Cela
permet d'afficher la date du jour au dessus de plusieurs billets du mme
jour.

On peut entourer la date de marqueur ou de texte grce  la chane
de substitution __s__ passe en argument. Par exemple:

|<?php dcDayDate('<h2>%s</h2>'); ?>

@proto function dcDayDate

@param string s Chaine de substition ('%s')
*/
function dcDayDate($s='%s')
{
	if ($GLOBALS['news']->firstPostOfDay())
	{
		printf($s,$GLOBALS['news']->getLDate());
	}
}

/**
Cette fonction affiche un calendrier contextuel (mois, anne, jour).
Le calendrier est un tableau dans une balise <div> dont la classe
??CSS|Cascading Style Sheet??
est ''cal''. Les nom des jours sont indiqus avec des cellules d'en-tte
(th) et le titre
avec (caption).

Exemple d'utilisation :

|<?php dcCalendar(); ?>

@proto function dcCalendar
*/
function dcCalendar()
{
	global $year,$month,$day,$cat_id;
	
	echo $GLOBALS['blog']->xCalendar($year,$month,$day,$cat_id);
}

/**
Cette fonction affiche les liens (link) dans l'en-tte du fichier HTML.
Elle gnre automatiquement les liens de naviguation dans le blog. Il
suffit de la placer dans l'en-tte du document :

|<head>
|<?php dcHeadLinks(); ?>
|</head>

@proto function dcHeadLinks
*/
function dcHeadLinks()
{
	global $blog, $cat_id;
	
	echo dcPostNext(1,'<link rel="next" href="%3$s" title="%2$s" />'."\n");
	echo dcPostNext(-1,'<link rel="previous" href="%3$s" title="%2$s" />'."\n");
	
	$rs_cat = $GLOBALS['rs_cat'];
	if (!$rs_cat->isEmpty() && !$cat_id)
	{
		while (!$rs_cat->EOF())
		{
			if ($rs_cat->f('nb_post') > 0)
			{
				$id = $rs_cat->f('cat_libelle_url');
				$libelle = $rs_cat->f('cat_libelle');
				$lien = sprintf($blog->front_url['cat'],$id);
				
				echo '<link rel="section" href="'.$lien.'" title="'.$libelle.'" />'."\n";
			}
			$rs_cat->moveNext();
		}
	}
	
	$arry_months = $GLOBALS['arry_months'];
	$comp_url = '';
	if ($cat_id) {
		$comp_url = $cat_id.'/';
	}
	foreach ($arry_months as $ts => $d)
	{
		$titre = strftime('%B %Y',$ts);
		$url = sprintf($blog->front_url['archive'],$comp_url.date('Y',$ts),date('m',$ts));
		echo '<link rel="archive" href="'.$url.'" title="'.$titre.'" />'."\n";
	}
	
	if ($GLOBALS['mode'] == 'home')
	{
		$news = $GLOBALS['news'];
		while (!$news->EOF())
		{
			echo '<link rel="chapter" href="'.$news->getPermURL().'" '.
			'title="'.$news->f('post_titre').'" />'."\n";
			$news->moveNext();
		}
	}
}

/**
Cette fonction affiche le titre d'un billet si on est sur une page prsentant
un billet (/blog/yyyy/mm/dd/titre par exemple).

On l'utilisera dans la balise <title> du document. Par exemple:

|<title><?php dcSinglePostTitle(); ?></title>

@proto function dcSinglePostTitle

@param string s Chane de substitution ('%s')
*/
function dcSinglePostTitle($s='%s - ')
{
	if ($GLOBALS['mode'] == 'post') {
		printf($s,$GLOBALS['news']->f('post_titre'));
	}
}

/**
Cette fonction affiche le nom de la catgorie s'il y a lieu de l'afficher. On peut
l'utiliser dans le titre, comme __dcSinglePostTitle__.

@proto function dcSingleCatTitle
@param string s Chane de substitution
*/
function dcSingleCatTitle($s='%s - ')
{
	if ($GLOBALS['cat_id'] != '') {
		printf($s,$GLOBALS['news']->f('cat_libelle'));
	}
}

/**
Cette fonction affiche le mois et l'anne en cours s'il y a lieu de l'afficher.
S'utilise aussi dans le titre comme __dcSinglePostTitle__.

@proto function dcSingleMonthTitle
@param string s Chane de substitution
*/
function dcSingleMonthTitle($s='%s - ')
{
	if ($GLOBALS['mode'] == 'month') {
		$ts = strtotime($GLOBALS['year'].'-'.$GLOBALS['month'].'-01 00:00');
		printf($s,strftime('%B %Y',$ts));
	}
}

/**
@proto doc

! Exemples d'usage des fonctions pour la balise <title>

Voici un exemple de commun de balise <title>  partir des fonctions prcdentes :

|<title><?php dcSinglePostTitle('%s - ').dcSingleCatTitle('%s - ').
|dcSingleMonthTitle('%s - ').dcInfo(); ?></title>
*/



/**
Cette fonction affiche une liste des catgories avec les liens pour y
accder. La liste gnre est une liste non ordonne (<ul>), il est donc
trs simple de la mettre en forme par la suite.

@proto function dcCatList
*/
function dcCatList()
{
	global $rs_cat, $cat_id, $blog;
		
	if (!$rs_cat->isEmpty())
	{
		echo '<ul>';
		while (!$rs_cat->EOF())
		{
			if ($rs_cat->f('nb_post') > 0)
			{
				$id = $rs_cat->f('cat_libelle_url');
				$libelle = $rs_cat->f('cat_libelle');
				
				$lien = '<a href="'.
				sprintf($blog->front_url['cat'],$id).
				'">'.$libelle.'</a>';
				
				if ($cat_id == $id) {
					$lien = '<strong>'.$lien.'</strong>';
				}
				
				echo '<li>'.$lien.'</li>';
			}
			$rs_cat->moveNext();
		}
		echo '</ul>';
	}
}

/**
Cette fonction affiche la liste des mois contenant les archives.
Si on se trouve dans une catgorie, seuls les mois de cette catgorie
seront affichs.

@proto function dcMonthsList
*/
function dcMonthsList()
{
	global $arry_months, $month, $year, $cat_id, $blog;
	
	$comp_url = '';
	if($cat_id) {
		$comp_url = $cat_id.'/';
	}
	
	echo '<ul>';
	foreach($arry_months as $ts => $d)
	{
		$titre = strftime('%B %Y',$ts);
		
		$url = sprintf($blog->front_url['archive'],$comp_url.date('Y',$ts),date('m',$ts));
		$lien = '<a href="'.$url.'">%s</a>';
		
		$liClass = '';
		
		if($year == date('Y',$ts) && $month == date('m',$ts)) {
			$lien = '<strong>'.$lien.'</strong>';
		}
		
		echo '<li>'.sprintf($lien,$titre).'</li>';
	}
	echo '</ul>';
}

/**
Cette fonction affiche la chane de recherche lorsque qu'une recherche vient d'tre
effectue.

@proto function dcSearchString

@param string s Chane de substitution ('%s')
*/
function dcSearchString($s='%s')
{
	if(!empty($_GET['q'])) {
		printf($s,stripslashes($_GET['q']));
	}
}


# Billets #################################################
/**
@proto doc

!! Traitement des billets.

Les fonctions suivantes doivent tre utilises uniquement dans un
contexte de billet. Cela signifie qu'on l'utilisera si __$mode__
vaut 'post' ou dans une boucle de billet. Exemple:

|<?php if ($mode == 'post') : ?>
| on peut utiliser les fonctions.
|<?php endif; ?>

L'affichage des listes de billets est gr par une boucle trs simple
 mettre en place. Voici un exemple qui affiche le titre des billets :

|<?php while (!$news->EOF()) : ?>
|<h3><?php dcPostTitle(); ?></h3>
|<?php $news->moveNext(); endwhile; ?>

*/

/**
Cette fonction affiche l'URI du billet, son permalien. On l'utilisera dans
l'affichage d'un billet (boucle ou pas). Par exemple:

|<a href="<?php dcPostURL(); ?>">lien permanent</a>

@proto function dcPostURL
*/
function dcPostURL()
{
	echo $GLOBALS['news']->getPermURL();
}

/**
Cette fonction affiche l'ID du billet (son numro identifiant unique).

@proto function dcPostID
*/
function dcPostID()
{
	echo $GLOBALS['news']->f('post_id');
}

/**
Cette fonction affiche le titre d'un billet, avec chane de substitution
possible. Exemple:

|<h2><?php dcPostTitle(); ?></h2>

@proto function dcPostTitle
*/
function dcPostTitle($s='%s')
{
	printf($s,$GLOBALS['news']->f('post_titre'));
}

/**
Dans le contexte du billet, cette fonction affiche le nom de la catgorie
du billet.

@proto function dcPostCatTitle
*/
function dcPostCatTitle()
{
	echo $GLOBALS['news']->f('cat_libelle');
}

/**
Cette fonction affiche l'URL de la catgorie d'un billet. Ne s'utilise que dans
le contexte d'un billet. Par exemple:

|<a href="<?php dcPostCarURL(); ?>"><?php dcPostCatTitle(); ?></a>

@proto function dcPostCatURL
*/
function dcPostCatURL()
{
	echo $GLOBALS['news']->getCatURL();
}

/**
Cette fonction affiche le contenu d'un billet (sans son chap). On peut
limiter le nombre de mots affichs avec le paramre __part__.
Si __part__ vaut 0 alors on affiche tout le billet.

@proto function dcPostContent
@param integer part Nombre de mots  afficher
*/
function dcPostContent($part=0)
{
	global $news;
		
	if ($part > 0) {
		echo $news->blog->getPart($news->f('post_content'),$part);
	} else {
		echo $news->getContent();
	}
}

/**
Cette fonction affiche le chap d'un billet s'il existe, sinon elle
n'affiche rien. Le paramtre __s__ permet d'ajouter des information lors
de l'affichage du chap. Exemple:

|<?php dcPostChapo('<h3>Chap</h3> %s'); ?>

@proto function dcPostChapo
@param string s Chaine de substitution ('%s <hr />')
*/
function dcPostChapo($s='%s <hr />')
{
	printf($s,$GLOBALS['news']->getChapo());
}

/**
Cette fonction affiche le chap du billet s'il y en a un sinon elle affiche
le contenu du billet. Si elle affiche le chap, le paramtre __l__ permet
de dfinir un texte  afficher aprs le chap. Dans le paramtre __l__ la
chane %s indique le lien vers le billet. On pourra donc par exemple faire
ceci :

|<?php dcPostAbstract('%s','<p><a href="%s">lire la suite</a></p>'); ?>

On notera que cette fonction trouve sa place dans un affichage de liste de
billets, plutt que dans l'affichage d'un seul billet.

@proto function dcPostAbstract
@param string s Chane de substitution du chap ('%s')
@param string l Chane affiche aprs le chap ('<p><a href="%s">lire la suite</a></p>')
*/
function dcPostAbstract($s='%s',$l='<p><a href="%s">lire la suite</a></p>')
{
	global $news;
		
	if ($news->f('post_chapo') != '') {
		printf($s,$news->getChapo());
		printf($l,$news->getPermURL());
	} else {
		echo $news->getContent();
	}
}

/**
Cette fonction affiche le nom canonique de l'auteur du billet. Le nom canonique
est dfini en fonction des informations donnes par le rdacteur. Si un pseudo
est prsent, il sera utilis, sinon, le prnom et le nom seront utiliss.

@proto function dcPostAuthor
*/
function dcPostAuthor()
{
	echo $GLOBALS['news']->getUserCN();
}

/**
Cette fonction affiche la date d'un billet. On peut changer le formatage
de la date en changeant le paramtre __format__. Par dfaut, ce paramtre
utilisera le format donn dans la configuration du blog.

Voir [strftime|http://fr2.php.net/manual/fr/function.strftime.php] pour les
formats possible de date.

@proto function dcPostDate
@param string format Masque de formatage de la date ('')
*/
function dcPostDate($format='')
{
	if ($format) {
		echo strftime($format,strtotime($GLOBALS['news']->f('post_dt')));
	} else {
		echo $GLOBALS['news']->getLDate();
	}
}

/**
Cette fonction affiche l'heure d'un billet en utilisant le format donn dans la
configuration du blog.

@proto function dcPostTime
*/
function dcPostTime($format='')
{
	echo $GLOBALS['news']->getLTime();
}

/**
Cette fonction affiche le nombre de commentaires d'un billet.
Les trois arguments permettent de dfinir le texte affich pour
respectivement aucun, un ou plusieurs commentaires. Par exemple:

|<?php dcPostNbComments('aucun commentaire','un commentaire',
|'%s commentaires'); ?>

@proto function dcPostNbComments
@param string zero Texte affich pour 0 commentaire
@param string one Texte affich pour 1 commentaire
@param string more Texte affich plusieurs commentaires
*/
function dcPostNbComments($zero,$one,$more)
{
	$nb = $GLOBALS['news']->f('nb_comment');
	
	if($nb == 0) {
		echo $zero;
	} elseif($nb == 1) {
		echo $one;
	} elseif($nb > 1) {
		printf($more,$nb);
	}
}

/**
Cette fonction permet d'afficher une information sur le billet suivant ou
prcdent. Le paramtre __dir__ indique la direction dans laquelle chercher
le billet (1 pour suivant, -1 pour prcdent). Le paramtre __s__ est une
chane de substitution permettant de formater l'affichage des informations
concernant le billet. Il y a trois paramtres  cette chane, donnant
respectivement l'ID, le titre et l'url du billet suivant ou prcdent. Cette
fonction n'affiche rien si elle ne trouve pas de billet.

On peut l'utiliser pour l'affichage individuel des billets, par exemple:

|<?php dcPostNext(1,'<a href="%3$s" title="%2$s">Billet suivant</a>'); ?>

Ceci affichera un lien vers le billet suivant s'il existe et ayant pour titre le
titre du billet.

@proto function dcPostNext
@param integer dir Direction (1)
@param string s Chane de substitution ('%1$s %2$s %3$s')
*/
function dcPostNext($dir,$s='%1$s %2$s %3$s')
{
	global $blog;
	
	if (empty($GLOBALS['rs_next']) || empty($GLOBALS['rs_next'])) {
		return false;
	}
	
	$rs = ($dir > 0) ? $GLOBALS['rs_next'] : $GLOBALS['rs_prev'];
	
	if (!$rs->isEmpty())
	{
		$id = $rs->f('post_id');
		$titre = $rs->f('post_titre');
		$date = $rs->f('post_dt');
		
		$ts = strtotime($date);
		
		$url = sprintf($blog->front_url['post'],date('Y',$ts),
		date('m',$ts),date('d',$ts),$id,$blog->str2url($titre));
	
		printf($s,$id,$titre,$url);
	}
}

/**
Cette fonction indique si les commentaires sont autoriss pour un commentaire.
On peut l'utiliser dans un test par exemple.

@proto function dcPostOpenComments
@return boolean
*/
function dcPostOpenComments()
{
	return (boolean) $GLOBALS['news']->f('post_open_comment');
}

/**
Cette fonction affiche l'URI  pinger pour faire un trackback sur un billet.

@proto function dcPostTrackbackURI
*/
function dcPostTrackbackURI()
{
	global $cf_trackback_uri;
	
	echo 'http://'.$_SERVER['HTTP_HOST'].
	sprintf($cf_trackback_uri,$GLOBALS['news']->f('post_id'));
}

/**
Cette fonction affiche le commentaire HTML contenant les informations
RDF permettant de raliser la dcouverte automatique de l'URL de trackback.
On l'utilisera dans l'en-tte du document de prfrence.

@proto function dcPostTrackbackAutoDiscovery
*/
function dcPostTrackbackAutoDiscovery()
{
	global $cf_trackback_uri;
	
	$tb_url = 'http://'.$_SERVER['HTTP_HOST'].
	sprintf($cf_trackback_uri,$GLOBALS['news']->f('post_id'));
	
	echo '<!--'."\n".
	'<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"'."\n".
	'  xmlns:dc="http://purl.org/dc/elements/1.1/"'."\n".
	'  xmlns:trackback="http://madskills.com/public/xml/rss/module/trackback/">'."\n".
	'<rdf:Description'."\n".
	'  rdf:about="http://'.$_SERVER['HTTP_HOST'].$GLOBALS['news']->getPermURL().'"'."\n".
	'  dc:identifier="http://'.$_SERVER['HTTP_HOST'].$GLOBALS['news']->getPermURL().'"'."\n".
	'  dc:title="'.$GLOBALS['news']->f('post_titre').'"'."\n".
	'  trackback:ping="'.$tb_url.'" />'."\n".
	'</rdf:RDF>'."\n".
	'-->'."\n";
}

# Commentaires ############################################
/**
@proto doc

!!Traitement des commentaires

Le traitement des commentaires est rgis par la mme systme de boucle
que les billets. Les fonctions suivantes ne s'utilisent que dans une
boucle de commentaires sauf __dcCommentFormError__ et __dcCommentFormValue__
qui peuvent tre utiliss partout.

Exemple d'une boucle de commentaires affichant son contenu

|<?php while (!$comments->EOF()) : ?>
| <?php dcCommentContent(); ?>
|<?php $comments->moveNext(); endwhile; ?>
*/

/**
Cette fonction affiche le contenu d'un commentaire.

@proto function dcCommentContent
*/
function dcCommentContent()
{
	echo $GLOBALS['comments']->xGetContent();
}

/**
Cette fonction affiche un commentaire de type trackback avec le lien vers
l'article dans le corps du commentaire (autour du titre). Sinon, il affiche
que le commentaire comme dcCommentContent().

@proto function dcCommentContentTransform
*/
function dcCommentContentTransform()
{
	$content = $GLOBALS['comments']->xGetContent();
	$link = '<a href="'.$GLOBALS['comments']->auteurSite().'">$2</a>';
	
	if ((boolean) $GLOBALS['comments']->f('comment_trackback'))
	{
		echo preg_replace('|(<p><strong>)(.*)(</strong></p>)|msU','$1'.$link.'$3',$content);
	}
	else
	{
		echo $content;
	}
}

/**
Cette fonction affiche la date d'un commentaire. On peut changer le formatage
de la date en changeant le paramtre __format__. Par dfaut, ce paramtre
utilisera le format donn dans la configuration du blog.

Voir [strftime|http://fr2.php.net/manual/fr/function.strftime.php] pour les
formats possibles de date.

@proto function dcCommentDate
@param string format Masque de formatage de la date ('')
*/
function dcCommentDate($format='')
{
	 if ($format) {
		echo strftime($format,strtotime($GLOBALS['comments']->f('comment_dt')));
	} else {
		echo $GLOBALS['comments']->getLDate();
	}
}

/**
Cette fonction affiche l'heure d'un commentaire en utilisant le format donn
dans la configuration du blog.

@proto function dcCommentTime
*/
function dcCommentTime()
{
	echo $GLOBALS['comments']->getLTime();
}

/**
Cette fonction affiche le pseudo de l'auteur d'un commentaire.

@proto function dcCommentAuthor
*/
function dcCommentAuthor()
{
	echo $GLOBALS['comments']->f('comment_auteur');
}

/**
Cette fonction affiche l'ID d'un commentaire

@proto function dcCommentID
*/
function dcCommentID()
{
	echo $GLOBALS['comments']->f('comment_id');
}

/**
Cette fonction affiche le nom de l'auteur avec un lien
vers son adresse email s'il en a laiss une.

@proto function dcCommentAuthorLink
@param string s Chane de substitution
*/
function dcCommentAuthorLink($s='%s')
{
	if (($link = $GLOBALS['comments']->auteurLink()) !== false) {
		printf($s,$link);
	}
}

/**
Cette fonction affiche un lien vers le site de l'auteur d'un commentaire
s'il en a laiss un.

@proto function dcCommentAuthorSite
@param string s Chane de substitution
*/
function dcCommentAuthorSite($s='%s')
{
	if (($link = $GLOBALS['comments']->auteurSite()) !== false) {
		printf($s,$link);
	}
}

/**
Cette fonction affiche les erreurs qui ont pu se produire lors de la soumission
d'un commentaire. Il est conseill de la laisser.

@proto function dcCommentFormError
@param string s Chane de substitution
*/
function dcCommentFormError($s='%s')
{
	if (!empty($GLOBALS['form_err'])) {
		printf($s,$GLOBALS['form_err']);
	}
}

/**
Cette fonction affiche la valeur d'une variable pour le formulaire de
commentaire. Elle permet par exemple de rappeler les valeurs en cas d'erreur.
Les valeurs possibles de __var__ sont :

* c_nom : nom
* c_mail : adresse email
* c_site : site web
* c_content : contenu du commentaire

On pourra utiliser par exemple:

|<input name="c_nom" id="c_nom" type="text" size="30" maxlength="255"
|value="<?php dcCommentFormValue('c_nom'); ?>" />

@proto function dcCommentFormValue
@param string var Nom de la variable  afficher
*/
function dcCommentFormValue($var)
{
	echo htmlspecialchars($GLOBALS[$var]);
}

/**
Cette fonction donne l'url vers laquelle on redirige le client une fois
le commentaire post.

@proto function dcCommentFormRedir
*/
function dcCommentFormRedir()
{
	echo getPageURL();
}

/**
Cette fonction indique si un commentaire est un trackback.

@proto function dcCommentIsTrackBack
@return boolean 
*/
function dcCommentIsTrackBack()
{
	return (boolean) $GLOBALS['comments']->f('comment_trackback');
}

/**
Cette fonction retourne l'URL du trackback. Il s'agit en fait de l'URL
du site dans le commentaire. Elle fait simplement un test supplmentaire
pour vrifier que le commentaire est bien un trackback.

@proto function dcCommentTrackBackURL
*/
function dcCommentTrackBackURL($s='%s')
{
	if ($GLOBALS['comments']->f('comment_trackback') == 1)
	{
		printf($s,$GLOBALS['comments']->f('comment_site'));
	}
}

?>