<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

#
# Extension de la classe blogcomment

class xblogcomment extends blogcomment
{
	function auteurLink()
	{
		if($this->f('comment_email') != '') {
			return $this->getEncodMail();
		} else {
			return false;
		}
	}
	
	function auteurSite()
	{
		if($this->f('comment_site') != '') {
			return 'http://'.$this->f('comment_site');
		} else {
			return false;
		}
	}
	
	function xGetContent()
	{
		if ($this->blog->use_smilies)	{
			return $this->blog->addSmilies($this->getContent());
		} else {
			return $this->getContent();
		}
	}
	
	function getRSSSeq()
	{
		# URL du lien permanent vers le billet
		$TS = $this->getTS();
		$y = date('Y',$TS);
		$m = date('m',$TS);
		$d = date('d',$TS);
		
		return '  <rdf:li rdf:ressource="c'.$this->f('comment_id').'" />'."\n";
	}
	
	function getRSSItem()
	{
		# URL du lien permanent vers le billet
		$TS = $this->getTS();
		$y = date('Y',$TS);
		$m = date('m',$TS);
		$d = date('d',$TS);
		
		$post_url = sprintf($this->blog->front_url['post'],$y,$m,$d,
				$this->f('post_id'),$this->blog->str2url($this->f('post_titre')));
		
		$content = $this->blog->getPart(strip_tags($this->getContent()),50).'...';
		$content = wordwrap($content,60);
		
		return
		'<item rdf:ID="c'.$this->f('comment_id').'">'."\n".
		'  <title>'.$this->blog->toXML($this->f('post_titre')).' - '.$this->blog->toXML($this->f('comment_auteur'))."</title>\n".
		'  <link>'.$post_url.'#c'.$this->f('comment_id')."</link>\n".
		'  <dc:date>'.$this->getIsoDate()."</dc:date>\n".
		'  <dc:creator>'.$this->blog->toXML($this->f('comment_auteur'))."</dc:creator>\n".
		'  <description>'.$this->blog->toXML($content)."</description>\n".
		'</item>'."\n";
	}
}


?>