<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

#
#  Extension de la classe blog
#

class xblog extends blog
{
	var $use_smilies = false;
	var $smilies_path = '';
	
	function setUseSmilies($v=false)
	{
		$this->use_smilies = (boolean) $v;
	}
	
	function setSmiliesPath($p)
	{
		$this->smilies_path = $p;
		
		# Tableau des smilies
		$def_path = $_SERVER['DOCUMENT_ROOT'].'/'.$this->smilies_path.'/smilies.txt';
		if ($this->use_smilies && file_exists($def_path))
		{
			$def = file($def_path);
			
			header('Content-Type: text/plain');
			
			$this->arry_smilies = array();
			foreach($def as $v)
			{
				$v = trim($v);
				if (preg_match('|^([^\t]*)[\t]+(.*)$|',$v,$matches))
				{
					$r = '/(\A|[\s]+|>)('.preg_quote($matches[1],'/').')([\s]+|[<]|\Z)/ms';
					$s = '$1<img src="'.$this->smilies_path.$matches[2].'" alt="$2" />$3';
					$this->arry_smilies[$r] = $s;
				}
			}
		}
	}
	
	function addSmilies($str)
	{
		if (!empty($this->arry_smilies) && is_array($this->arry_smilies))
		{
			return preg_replace(array_keys($this->arry_smilies),array_values($this->arry_smilies),$str);
		}
		else
		{
			return $str;
		}
	}
	
	function xCalendar($year,$month,$day,$cat_id)
	{		
		$arry_months = $GLOBALS['arry_months'];
				
		$comp_url = '';
		if($cat_id) {
			$comp_url = $cat_id.'/';
		}
		
		if($month == '' || $year == '') {
			$recent = $this->getEarlierDate($cat_id);
			$actual_month = date('m',strtotime($recent));
			$actual_year = date('Y',strtotime($recent));
		} else {
			$actual_month = $month;
			$actual_year = $year;
		}
		
		$days = $this->getAllDates('d',$actual_year,$actual_month,'',$cat_id);
		$ts = strtotime($actual_year.'-'.$actual_month.'-01');
		
		$first = date('w',$ts);
		
		$first = ($first == 0) ? 6 : ($first-1);
		
		# Limite de fin du mois
		$limit = date('t',$ts);
		
		# Mois suivant / prcdent
		$link_next = $link_prev = '';
		if (($l_next = getNextPrev($arry_months,$ts,'prev')) !== NULL) {
			$ts_next = key($l_next);
			$m_next = date('m',$ts_next);
			$y_next = date('Y',$ts_next);
			$link_next = ' <a href="'.
				sprintf($this->front_url['archive'],$comp_url.$y_next,$m_next).'" '.
				' title="'.strftime('%B %Y',$ts_next).'">&#187;</a>';
		}
		
		if (($l_prev = getNextPrev($arry_months,$ts,'next')) !== NULL) {
			$ts_prev = key($l_prev);
			$m_prev = date('m',$ts_prev);
			$y_prev = date('Y',$ts_prev);
			$link_prev = '<a href="'.
				sprintf($this->front_url['archive'],$comp_url.$y_prev,$m_prev).'" '.
				' title="'.strftime('%B %Y',$ts_prev).'">&#171;</a> ';
		}
		
		
		$d=1; $i=0; $dstart=false;
		
		$res = '<div class="cal"><table summary="calendrier">';
		$res .= '<caption>'.$link_prev.strftime('%B %Y',$ts).$link_next.'</caption>';
		$res .= '<thead><tr>';
		/* Timestamp d'un lundi (6/1/2003)     : 1041807600
		   Timestamp d'un dimanche (12/1/2003) : 1042326000
		*/
		for($j=1041807600;$j<=1042326000;$j=$j+86400) {
			$res .= '<th scope="col"><abbr title="'.strftime('%A',$j).'">'.
			strftime('%a',$j).'</abbr></th>';
		}
		$res .= '</tr></thead>';
		
		$res .= '<tbody>';
		while($i<42)
		{
			if($i%7 == 0)
				$res .= '<tr>';
			
			if($i == $first) {
				$dstart = true;
			}
			
			if($dstart && !checkdate($actual_month,$d,$actual_year)) {
				$dstart = false;
			}
			
			if(!empty($days[strtotime($actual_year.'-'.$actual_month.'-'.$d)])) {
				$url = sprintf($this->front_url['day'],$comp_url.$actual_year,$actual_month,$d);
				$link = '<a href="'.$url.'">%s</a>';
			} else {
				$link = '%s';
			}
			
			$class = ($day == $d) ? ' class="active"' : '';
			
			$res .= '<td'.$class.'>';
			$res .= ($dstart) ? sprintf($link,$d) : ' ';
			$res .= '</td>';
			
			if(($i+1)%7 == 0)
			{
				$res .= '</tr>';
				if ($d>=$limit) { $i=42; }
			}
			
			$i++;
			if($dstart) { $d++; }
		}
		
		$res .= '</tbody></table></div>';
		
		return $res;
	}
}
?>