<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

/* cassage des magic_quotes */
function magicStrip(&$k,$key)
{
	if(get_magic_quotes_gpc()) {
		$k = handleMagicQuotes($k);
	}
}

function handleMagicQuotes(&$value)
{
	if (get_magic_quotes_gpc())
	{
		if (is_array($value))
		{
			$result = array();
			foreach ($value as $k => $v)
			{
				if (is_array($v)) {
					$result[$k] = handleMagicQuotes($v);
				} else {
					$result[$k] = stripslashes($v);
				}
			}
			return $result;
		}
		else
		{
			return stripslashes($value);
		}
	}
	return $value;
}


if(!empty($_GET)) {
	array_walk($_GET,'magicStrip');
}
if(!empty($_POST)) {
	array_walk($_POST,'magicStrip');
}
if(!empty($_REQUEST)) {
	array_walk($_REQUEST,'magicStrip');
}
if(!empty($_COOKIE)) {
	array_walk($_COOKIE,'magicStrip');
}

require dirname(__FILE__).'/class.mysql.php';
require dirname(__FILE__).'/class.blog.php';
require dirname(__FILE__).'/class.wiki2xhtml.php';
require dirname(__FILE__).'/lib.auth.php';
require dirname(__FILE__).'/lib.form.php';
require dirname(__FILE__).'/lib.utils.php';
?>