<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****
 
# Retourne une paire de l'lment suivant ou prcdent d'un tableau 
# un indice donn
function getNextPrev($array,$key,$mode)
{
	$keys = array_keys($array);
	$values = array_values($array);
	$p = array_flip($keys);
	$pos = $p[$key];
	
	
	if($mode == 'next') {
		return ($pos+1 < count($array)) ? array($keys[$pos+1] => $values[$pos+1]) : NULL;
	} else {
		return ($pos > 0) ? array($keys[$pos-1] => $values[$pos-1]) : NULL;
	}
}


function my_size($size)
{
	$kb = 1024;
	$mb = 1024 * $kb;
	$gb = 1024 * $mb;
	$tb = 1024 * $gb;
	
	if($size < $kb) {
		return $size." B";
	}
	else if($size < $mb) {
		return round($size/$kb,2)." KB";
	}
	else if($size < $gb) {
		return round($size/$mb,2)." MB";
	}
	else if($size < $tb) {
		return round($size/$gb,2)." GB";
	}
	else {
		return round($size/$tb,2)." TB";
	}
}

# Suppression d'un rpertoire (rm -rf)
function deltree($dir)
{
	$current_dir = opendir($dir);
	while($entryname = readdir($current_dir))
	{
		if (is_dir($dir.'/'.$entryname) and ($entryname != '.' and $entryname!='..'))
		{
			deltree($dir.'/'.$entryname);
		}
		elseif ($entryname != '.' and $entryname!='..')
		{
			@unlink($dir.'/'.$entryname);
		}
	}
	closedir($current_dir);
	@rmdir($dir);
}

# Obtenir l'url complte de la page
function getPageURL()
{
	$server_name = $_SERVER['SERVER_NAME'];
	if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on')
	{
		$scheme = 'https';
		$port = ($_SERVER['SERVER_PORT'] != '443') ? ':'.$_SERVER['SERVER_PORT'] : '';
	}
	else
	{
		$scheme = 'http';
		$port = ($_SERVER['SERVER_PORT'] != '80') ? ':'.$_SERVER['SERVER_PORT'] : '';
	}
	
	return $scheme.'://'.$_SERVER['SERVER_NAME'].$port.$_SERVER['REQUEST_URI'];
}
?>