<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

function dc_get_mod($blog_url,$args=NULL)
{
	$year = $month = $day = $post_id = $cat_id = $cat_name = NULL;
	$mode = 'home';
	
	$args = '';
	
	# On catch les arguments qui suivent l'url du script
	# Ensuite on vire les / du dbut et de la fin
	if (preg_match('/^'.str_replace('/','\/',$blog_url).'(.*)$/',$_SERVER['REQUEST_URI'],$match)) {
		$args = preg_replace('/^[\/]?(.*?)[\/]?$/','$1',$match[1]);
	}
	
		
	if($args != '')
	{
		/*if(preg_match('#^([0-9]{4})(/|\z)#',$args,$match))
		{
			$mode = 'year';
			$year = $match[1];
			*/
			if(preg_match('#^([0-9]{4})/([0-9]{2})(/|\z)#',$args,$match))
			{
				$mode = 'month';
				$year = $match[1];
				$month = $match[2];
				if(preg_match('#^([0-9]{4})/([0-9]{2})/([0-9]{2})(/|\z)#',$args,$match))
				{
					$mode = 'day';
					$day = $match[3];
					if(preg_match('#^([0-9]{4})/([0-9]{2})/([0-9]{2})/([0-9]+)#',$args,$match))
					{
						$mode = 'post';
						$post_id = $match[4];
					}
				}
			}
		//}
		elseif(preg_match('#^([A-Za-z_]+)([^/]*)?(/|\z)#',$args,$match))
		{
			$mode = 'cat';
			//$cat_name = $match[2];
			$cat_id = $match[1];
			if(preg_match('#^[A-Za-z_]+([^/]*)?/([0-9]{4})/([0-9]{2})#',$args,$match))
			{
				$mode = 'month';
				$year = $match[2];
				$month = $match[3];
				if(preg_match('#^[A-Za-z_]+([^/]*)?/([0-9]{4})/([0-9]{2})/([0-9]{2})#',$args,$match))
				{
					$mode = 'day';
					$day = $match[4];
				}
			}
		}
	}
	
	return array(
			'mode' => $mode,
			'year' => $year,
			'month' => $month,
			'day' => $day,
			'post_id' => $post_id,
			'cat_id' => $cat_id,
			'cat_name' => $cat_name
			);
}

?>