<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****
 
function auth($level)
{
	global $dbuser,$dbpass,$dbhost,$dbbase,$dbprefix;
	
	$failed = true;
	
	if (empty($_SESSION['sess_user_id'])) {
		$failed = true;
	} else {
		$con = new Connection($dbuser,$dbpass,$dbhost,$dbbase);
		
		$blog = new blog($con,$dbprefix);
				
		$failed = !$blog->checkUser($_SESSION['sess_user_id'],NULL,$level);
		
		$con->close();
		unset($blog);
	}
	
	if ($failed) {
		header('Location: auth.php');
		exit;
	}
}

function do_auth($user_id,$user_pwd,$level)
{
	global $dbuser,$dbpass,$dbhost,$dbbase,$dbprefix;
	$con = new Connection($dbuser,$dbpass,$dbhost,$dbbase);
	$blog = new blog($con,$dbprefix);
	
	if($blog->checkUser($user_id,$user_pwd,$level) !== false) {
		$rs = $blog->getUser($user_id);
		
		$_SESSION['sess_user_level'] = $rs->field('user_level');
		$_SESSION['sess_user_format']= $rs->field('user_post_format');
		$_SESSION['sess_user_nom'] = $rs->field('user_nom');
		$_SESSION['sess_user_prenom'] = $rs->field('user_prenom');
		$_SESSION['sess_user_pseudo'] = $rs->field('user_pseudo');
		$_SESSION['sess_user_email'] = $rs->field('user_email');
		$_SESSION['sess_user_edit_size'] = $rs->field('user_edit_size');
		$_SESSION['sess_user_pref_cat'] = (integer) $rs->field('user_pref_cat');
		
		if($_SESSION['sess_user_pseudo'] != '')
			$_SESSION['sess_user_cn'] = $_SESSION['sess_user_pseudo'];
		else
			$_SESSION['sess_user_cn'] = trim($_SESSION['sess_user_prenom'].' '.$_SESSION['sess_user_nom']);
		
		return true;
	}
	
	$con->close();
	unset($blog);
}

function user_level($level)
{
	return $_SESSION['sess_user_level'] >= $level;
}

?>