<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
# Stephanie Booth
# Mathieu Pillard
# Christophe Bonijol
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****


# Version : 2.0
# Release date : Sunday 2003-06-29

# History :
#
# Stephanie	=> correction des PCRE et ajout de fonctionnalits
# Mathieu 	=> ajout du strip-tags, implementation des options, reconnaissance automatique d'url, etc.
# Olivier		=> chagement de active_link en active_urls
#			=> ajout des options pour les blocs
#			=> intgration de l'aide dans le code, avec les options
#			=> dbut de quelque chose pour la reconnaissance auto d'url (avec Mat)

# TODO :
# Mathieu	=> active_wiki_urls (modifier wikiParseUrl ?)
# 		=> active_auto_urls
#
# *		=> ajouter des options.
# 		=> trouver un meilleur nom pour active_link ? (pour le jour ou ca sera tellement une usine
#		   a gaz que on generera des tags <link> :)
#
 
class wiki2xhtml
{
	var $opt;
	
	function wiki2xhtml()
	{
		# Tableau des abrviations
		$this->acro_table = $this->getAcronyms();
		
		# Mise en place des options
		$this->setOpt('active_title',1);		# Activation des titres !!!
		$this->setOpt('active_hr',1);			# Activation des <hr />
		$this->setOpt('active_lists',1);		# Activation des listes
		$this->setOpt('active_quote',1);		# Activation du <blockquote>
		$this->setOpt('active_pre',1);		# Activation du <pre>
		$this->setOpt('active_auto_urls',0);	# Activation de la reconnaissance d'url
		$this->setOpt('active_urls',1);		# Activation des liens []
		$this->setOpt('active_anchor',1);		# Activation des ancres ~...~
		$this->setOpt('active_em',1);			# Activation du <em> ''...''
		$this->setOpt('active_strong',1);		# Activation du <strong> __...__
		$this->setOpt('active_br',1);			# Activation du <br /> %%%
		$this->setOpt('active_q',1);			# Activation du <q> {{...}}
		$this->setOpt('active_code',1);		# Activation du <code> @@...@@
		$this->setOpt('active_acronym',1); 	# Activation des acronymes
		
		# Activation de la syntaxe franaise
		# placement d'espace inscable devant les ! ? ; et : prcds d'espaces
		$this->setOpt('active_fr_syntax',0);
		
		$this->setOpt('active_fix_word_entities',1);
	}
	
	function setOpt($option, $value)
	{
		$this->opt[$option] = (boolean) $value;
	}
	
	function getOpt($option)
	{
		return (!empty($this->opt[$option])) ? $this->opt[$option] : false;
	}
	
	function transform($string)
	{
		$string = str_replace("\r", '', $string);
		$string = str_replace("\t", ' ', $string);

		$T = explode("\n", $string);
		$T[] = "\n";

		## Application du parseur rcursif
		$res = $this->wikiParseRecursif($T, 0);

		## Application des autres contraintes (gras, italique, liens)
		# Emphase
		if ($this->getOpt('active_em'))
		{
			$res = preg_replace("/''(.*)''/msU",'<em>$1</em>', $res);
		}
		
		# Forte emphase
		if ($this->getOpt('active_strong'))
		{
			$res = preg_replace('/__(.*)__/msU', '<strong>$1</strong>', $res);
		}
		
		# Line break
		if ($this->getOpt('active_br'))
		{
			$res = str_replace('%%%', '<br />', $res);
		}
		
		# Correction de syntaxe franaise	
		# Sur ide de Christophe Bonijol
		if ($this->getOpt('active_fr_syntax'))
		{
			$res = preg_replace('/ ([:?!;])/','&nbsp;$1',$res);
		}
		
		# Correction des caractres faits par certains traitement
		# de texte comme Word
		if ($this->getOpt('active_fix_word_entities'))
		{
			$wR = array(
			'' => '&#8218;',
			'' => '&#402;',
			'' => '&#8222;',
			'' => '&#8230;',
			'' => '&#8224;',
			'' => '&#8225;',
			'' => '&#710;',
			'' => '&#8240;',
			'' => '&#352;',
			'' => '&#8249;',
			'' => '&#338;',
			'' => '&#8216;',
			'' => '&#8217;',
			'' => '&#8220;',
			'' => '&#8221;',
			'' => '&#8226;',
			'' => '&#8211;',
			'' => '&#8212;',
			'' => '&#732;',
			'' => '&#8482;',
			'' => '&#353;',
			'' => '&#8250;',
			'' => '&#339;',
			'' => '&#376;',
			'' => '&#8364;');
			
			$res = str_replace(array_keys($wR),array_values($wR),$res);
		}
		
		# URL, transformes en [url_courte|url]
		# A retravailler encore pour que a fonctionne trs bien
		if ($this->getOpt('active_auto_urls'))
		{
			$res = preg_replace_callback('/(?<!\[)(http):(\/\/)?([^\s]*)/msi',
								array($this,'wikiParseSimpleUrl'),$res);
		}
		
		# Liens
		# Protgs par des assertions arrires
		if ($this->getOpt('active_urls'))
		{
			$res = preg_replace_callback('/(?<!\\\)\[(.+)]/msU', 
					             array($this,'wikiParseUrl'), $res);
			$res = ereg_replace('\\\(\[|\])', '\\1', $res);
		}
		
		# Acronymes
		if ($this->getOpt('active_acronym'))
		{
			$res = preg_replace_callback('/\?\?(.+)\?\?/msU',
					array($this,'wikiParseAcronym'),$res);
		}
		
		# Citations
		if ($this->getOpt('active_q'))
		{
			# Citation simple
			$res = preg_replace('/\{\{([^|]+)\}\}/msU', '<q>$1</q>', $res);
		
			# Citation avec langue
			$res = preg_replace('/\{\{([^|]+)\|([^|]*)\}\}/msU', '<q lang="$2">$1</q>', $res);

			# Citation avec langue et url
			$res = preg_replace('/\{\{([^|]+)\|([^|]*)\|([^|]*)\}\}/msU', 
					    '<q lang="$2" cite="$3">$1</q>', $res);
		}
	     
		# Ajout d'une ~ancre~ (Stephanie)
		if ($this->getOpt('active_anchor'))
		{
			$res = preg_replace('/(?<!\\\)~([^~]+)(?<!\\\)~/ms', '<a name="$1" id="$1"> </a>', $res);
			$res = str_replace('\~', '~', $res);
		}
		
		# Ajout d'un @@code@@ (Olivier)
		if ($this->getOpt('active_code'))
		{
			$res = preg_replace('/@@([^~]+)@@/msU', '<code>$1</code>', $res);
		}
		
		# Nettoyage des \s en trop
		$res = preg_replace('/([\s]+)(<\/p>|<\/li>|<\/pre>)/', '$2', $res);
		$res = preg_replace('/(<li>)([\s]+)/', '$1', $res);

		return $res;
	}
	
	function wikiParseRecursif(&$T, $i, $mode = '')
	{
		$str = htmlspecialchars($T[$i], ENT_NOQUOTES) . "\n";
	        
		$res = '';
		## Formatage
		# Titres
		if (ereg('^([!]{1,3})(.*)$', $str, $cap) && $this->getOpt('active_title'))
		{
			if (strlen($cap[1]) == 3)
			{
				$t = 'h1';
			}
			elseif (strlen($cap[1]) == 2)
			{
				$t = 'h2';
			}
			else
			{
				$t = 'h3';
			}
			
			$res .= '<' . $t . '>' . trim($cap[2]) . '</' . $t . '>' . "\n";
		}
		# Ligne horizontale
		elseif (ereg('^[-]{4}([- ]*)$', trim($str)) && $this->getOpt('active_hr'))
		{
			$res .= "\n<hr />";
		}
		# Liste
		elseif (ereg('^([*#]+)(.*)', $str, $cap) && $this->getOpt('active_lists'))
		{
			$dl = ($mode == '') ? 0 : strlen($mode);
			$d = strlen($cap[1]);
			$delta = $d - $dl;
			
			if($delta > 0)
			{
				if(substr($cap[1], -1, 1) == '*')
				{
					$res .= "<ul>\n";
				}
				else
				{
					$res .= "<ol>\n";
				}
			}
			elseif ($delta < 0)
			{
				$res .= "</li>\n";
				for($j = 0; $j < abs($delta); $j++)
				{
					if (substr($mode,(0 - $j - 1), 1) == '*')
					{
						$res .= "</ul>\n</li>\n";
					}
					else
					{
						$res .= "</ol>\n</li>\n";
					}
				}
			}
			else
			{
				$res .= "</li>\n";
			}
			
			$mode = $cap[1];
			$res .= '<li>' . $cap[2] . "\n";
		}
		# Bloc pre
		elseif (ereg('^[ ]{1,2}(.*)$', $str, $cap) && trim($str) != '' && $this->getOpt('active_pre'))
		{
			if($mode != 'pre') {
				$mode = 'pre';
				$res .= "\n<pre>";
			}
			
			$res .= str_replace('&nbsp;',' ',$cap[1]);
		}
		# blockquote
		elseif (ereg('^(&gt;|;:)(.*)$', $str, $cap))
		{
			if ($mode != 'blockquote')
			{
				$mode = 'blockquote';
				$res .= "\n<blockquote><p>";
			}
			
			if (trim($cap[2]) == '')
			{
				$res .= "</p>\n<p>";
			}
			
			$res .= $cap[2];
		}
		# Ligne vide
		elseif (preg_match('/^[\s]*$/',$str))
		{
			if ($mode == 'p')
			{
				$res .= '</p>';
			}
			
			if ($mode == 'pre')
			{
				$res .= '</pre>';
			}
			
			if ($mode == 'blockquote')
			{
				$res .= '</p></blockquote>';
			}
			
			if (ereg('^[*#]+$', $mode))
			{
				for($j = 0; $j < strlen($mode); $j++)
				{
					if(substr($mode,(0 - $j - 1), 1) == '*')
					{
						$res .= "</li>\n</ul>";
					}
					else
					{
						$res .= "</li>\n</ol>";
					}
				}
			}
			
	          $res .= "\n";
	          
	          $mode = '';
		}
		# Paragraphe
		else
		{
			if($mode != 'p')
			{
				$mode = 'p';
				$res .= "\n<p>";
			}
			$res .= $str;
		}
		
		
		/* Recursion */
		if($i + 1 < count($T))
		{
			$res .= $this->wikiParseRecursif($T, $i+1, $mode);
		}
		
		return $res;
	}
	
	function wikiParseUrl($matches)
	{
		# Tableau des correspondances d'url spciales
		$array_url = $this->special_url();
		
		$data = explode('|', $matches[1]);
		
		if (count($data) == 1)
		{
			$url = trim($data[0]);
			$content = $url;
			$lang = '';
			$title = '';
		}
		elseif (count($data) > 1)
		{
			$url = trim($data[1]);
			$content = $data[0];
			$lang = (!empty($data[2])) ? $data[2] : '';
			$title = (!empty($data[3])) ? $data[3] : '';
		}
		
		$url = preg_replace(array_flip($array_url),$array_url,$url);
		
		# On vire les &nbsp; dans l'url
		$url = str_replace('&nbsp;',' ',$url);
		
		if (ereg('^(.+)[.](gif|jpg|jpeg|png)$', $url))
		{
			# On ajoute les dimensions de l'image si locale
			# Ide de Stephanie
			$img_size = NULL;
			if (!ereg('[a-zA-Z]+://', $url))
			{
				if (ereg('^/',$url))
				{
					$path_img = $_SERVER['DOCUMENT_ROOT'] . $url;
				}
				else
				{
					$path_img = $url;
				}
				$img_size = @getimagesize($path_img);
			}
			
			$res = '<img src="' . $url . '" alt="' . $content . '"';
			$res .= ($lang) ? ' lang="' . $lang . '"' : '';
			$res .= ($title) ? ' title="' . $title . '"' : '';
			$res .= (is_array($img_size)) ? ' ' . $img_size[3] : '';
			$res .= ' />'; 
		}
		else
		{
			$res = '<a href="' . $url . '"';
			$res .= ($lang) ? ' hreflang="' . $lang . '"' : '';
			$res .= ($title) ? ' title="' . $title . '"' : '';
			$res .= '>' . $content;
			$res .= '</a>';
		}
		
		return $res;
	}
	
	function special_url()
	{
		$res['#^google://(.*)$#'] = 'http://www.google.com/search?q=$1&amp;start=0&amp;start=0';
		
		return $res;
	}
	
	function wikiParseSimpleUrl($matches)
	{
		$url = $matches[1].':'.$matches[2].$matches[3];
		$title = (strlen($url)>30) ? substr($url,0,30).'...' : NULL;
		
		return ($title) ? '['.$title.'|'.$url.'||'.$url.']' : '['.$url.']';
	}
	
	function wikiParseAcronym($matches)
	{
		$data = explode('|',$matches[1]);
		
		if (count($data) == 1)
		{
			$acronym = $data[0];
			$title = '';
			$lang = '';
		}
		elseif (count($data) > 1)
		{
			$acronym = $data[0];
			$title = $data[1];
			$lang = (!empty($data[2])) ? $data[2] : '';
		}
		
		if ($title == '' && !empty($this->acro_table[$acronym])) {
			$title = $this->acro_table[$acronym];
		}
		
		$res = '<acronym';
		$res .= ($title) ? ' title="'.$title.'"' : '';
		$res .= ($lang) ? ' lang="'.$lang.'"' : '';
		$res .= '>'.$acronym;
		$res .= '</acronym>';
		
		return $res;
	}
	
	function help()
	{
		$help['b'] = array();
		$help['i'] = array();
		
		$help['b'][] = '<strong>Laisser une ligne vide entre chaque bloc.</strong>';
		$help['b'][] = '<strong>Paragraphe</strong> : du texte et une ligne vide';
		
		if ($this->getOpt('active_title')) {
			$help['b'][] = '<strong>Titre</strong> : <code>!!!</code>, <code>!!</code>, '.
			'<code>!</code> pour des titres plus ou moins importants';
		}
		
		if ($this->getOpt('active_hr')) {
			$help['b'][] = '<strong>Trait horizontal</strong> : <code>----</code>';
		}
		
		if ($this->getOpt('active_lists')) {
			$help['b'][] = '<strong>Liste</strong> : ligne dbutant par <code>*</code> ou '.
			'<code>#</code>. Il est possible de mlanger les listes '.
			'(<code>*#*</code>) pour faire des listes de plusieurs niveaux. '.
			'Respecter le style de chaque niveau';
		}
		
		if ($this->getOpt('active_pre')) {
			$help['b'][] = '<strong>Texte prformat</strong> : espace devant chaque ligne de texte';
		}
		
		if ($this->getOpt('active_quote')) {
			$help['b'][] = '<strong>Bloc de citation</strong> : <code>&gt;</code> ou '.
			'<code>;:</code> devant chaque ligne de texte';
		}
		
		if ($this->getOpt('active_fr_syntax')) {
			$help['i'][] = 'La correction de ponctuation est active. Un espace '.
						'inscable remplacera automatiquement tout espace '.
						'prcdant les marque ";","?",":" et "!".';
		}
		
		if ($this->getOpt('active_em')) {
			$help['i'][] = '<strong>Emphase</strong> : deux apostrophes <code>\'\'texte\'\'</code>';
		}
		
		if ($this->getOpt('active_strong')) {
			$help['i'][] = '<strong>Forte emphase</strong> : deux tirets <code>__texte__</code>';
		}
		
		if ($this->getOpt('active_em') && $this->getOpt('active_strong')) {
			$help['i'][] = 'On peut mlanger les emphase, ex: <code>\'\'__texte__\'\'</code>';
		}
		
		if ($this->getOpt('active_br')) {
			$help['i'][] = '<strong>Retour forc  la ligne</strong> : <code>%%%</code>';
		}
		
		if ($this->getOpt('active_urls')) {
			$help['i'][] = '<strong>Lien</strong> : <code>[url]</code>, <code>[nom|url]</code>, '.
			'<code>[nom|url|langue]</code> ou <code>[nom|url|langue|titre]</code>';
			
			$help['i'][] = '<strong>Image</strong> : comme un lien mais avec une extension d\'image';
		}
		
		if ($this->getOpt('active_anchor')) {
			$help['i'][] = '<strong>Ancre</strong> : <code>~ancre~</code>';
		}
		
		if ($this->getOpt('active_acronym')) {
			$help['i'][] = '<strong>Acronyme</strong> : <code>??acronyme??</code> ou '.
			'<code>??acronyme|titre??</code>';
		}
		
		if ($this->getOpt('active_q')) {
			$help['i'][] = '<strong>Citation</strong> : <code>{{citation}}</code>, '.
			'<code>{{citation|langue}}</code> ou <code>{{citation|langue|url}}</code>';
		}
		
		if ($this->getOpt('active_code')) {
			$help['i'][] = '<strong>Code</strong> : <code>@@code ici@@</code>';
		}
		
		$res = '<dl class="wikiHelp">';
		
		$res .= '<dt>Blocs</dt><dd>';
		if (count($help['b']) > 0)
		{
			$res .= '<ul><li>';
			$res .= implode('&nbsp;;</li><li>', $help['b']);
			$res .= '.</li></ul>';
		}
		$res .= '</dd>';
		
		$res .= '<dt>lments en ligne</dt><dd>';
		if (count($help['i']) > 0)
		{
			$res .= '<ul><li>';
			$res .= implode('&nbsp;;</li><li>', $help['i']);
			$res .= '.</li></ul>';
		}
		$res .= '</dd>';
		
		$res .= '</dl>';
		
		return $res;	
	}
	
	# Dfinition des acronymes, changez les  votre convenance
	function getAcronyms()
	{
		return array(
		'(X)HTML'		=> '(eXtensible) HyperText Markup Language',
		'AFNOR'		=> 'Association Franaise de NORmalisation',
		'ANSI'		=> 'American National Standard Institute',
		'ASCII'		=> 'American Standard Code for Information Interchange',
		'ASP'		=> 'Active Server Pages',
		'CSS'		=> 'Cascading Style Sheets',
		'DHTML'		=> 'Dynamic HyperText Markup Language',
		'DOM'		=> 'Document Object Model',
		'DTD'		=> 'Document Type Definition',
		'ECMA'		=> 'European Computer Manufacturer Association',
		'FAI'		=> 'Fournisseur d\'Acces  Internet',
		'FAQ'		=> 'Foire Aux Questions',
		'FTP'		=> 'File Transfer Protocol',
		'FIDEV'		=> 'Formation et Insertion pour DEficients Visuels',
		'HTML'		=> 'HyperText Markup Language',
		'HTTP'		=> 'HyperText Transfer Protocol',
		'IP'			=> 'Internet Protocol',
		'IRC'		=> 'Internet Relay Chat',
		'ISO'		=> 'International Standard Organization',
		'JS'			=> 'JavaScript',
		'MIME'		=> 'Multipurpose Internet Mail Extension',
		'P3P'		=> 'Platform for Privacy Preferences Project',
		'PC'			=> 'Personnal Computer',
		'PHP'		=> 'PHP: Hypertext Preprocessor',
		'PICS'		=> 'Platform for Internet Content Selection',
		'PNG'		=> 'Portable Network Graphics',
		'RDF'		=> 'Resource Description Framework',
		'RFC'		=> 'Request For Comment',
		'RSS'		=> 'RDF Site Summary',
		'SGML'		=> 'Standard Generalized Markup Language',
		'SMIL'		=> 'Synchronized Multimedia Integration Language',
		'SSII'		=> 'Socit de Service et d\'Ingnierie Informatique',
		'SVG'		=> 'Scalable Vector Graphics',
		'TAG'		=> 'Technical Architecture Group',
		'TCP'		=> 'Transmission Control Protocol',
		'URI'		=> 'Universal Resource Identifier',
		'URL'		=> 'Uniform Resource Locator',
		'URN'		=> 'Universal Resource Name',
		'W3C'		=> 'World Wide Web Consortium',
		'WAI'		=> 'Web Accessibility Initiative',
		'WYSIWYG'		=> 'What You See Is What You Get',
		'WWW'		=> 'World Wide Web',
		'XHTML'		=> 'eXtensible HyperText Markup Language',
		'XML'		=> 'eXtensible Markup Language',
		'XSL'		=> 'eXtensible Stylesheet Language',
		'XSLT'		=> 'eXtensible Stylesheet Language Transformation'
		);
	}
}
?>