<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/incutio/class.IXR_Library.php';

class DotClearRPC extends IXR_IntrospectionServer
{
	function DotClearRPC(&$blog)
	{
		$this->IXR_IntrospectionServer();
		
		$this->blog = $blog;
		
		$this->blog_url = '';
		$this->blog_name = '';
		
		# Mthodes blogger
		$this->addCallback('blogger.getUserInfo','this:blogger_getUserInfo',
			array('struct','string','string','string'),
			'Return User Info');
		
		$this->addCallback('blogger.getUsersBlogs','this:blogger_getUserBlogs',
			array('struct','string','string','string'),
			'Return user\'s blog');
		
		$this->addCallback('blogger.getPost','this:blogger_getPost',
			array('struct','string','integer','string','string'),
			'Return a posts by ID');
		
		$this->addCallback('blogger.getRecentPosts','this:blogger_getRecentPosts',
			array('struct','string','string','string','string','integer'),
			'Return a list of recent posts');
		
		$this->addCallback('blogger.newPost','this:blogger_newPost',
			array('string','string','string','string','string','string','integer'),
			'New post');
		
		$this->addCallback('blogger.editPost','this:blogger_editPost',
			array('boolean','string','string','string','string','string','integer'),
			'Edit a post');
		
		$this->addCallback('blogger.deletePost','this:blogger_deletePost',
			array('string','string','string','string','string','integer'),
			'Delete a post');
		
		# Mthodes B2
		$this->addCallback('b2.getCategories','this:b2_getCategories',
			array('struct','string','string','string'),
			'Return all categories');
	}
	
	
	function setBlogName($name)
	{
		$this->blog_name = $name;
	}
	
	function setBlogUrl($url)
	{
		$this->blog_url = $url;
	}
	
	# Mthodes blogger
	function blogger_getUserInfo($args)
	{
		return $this->_getUserInfo($args[1],$args[2]);
	}
	
	function blogger_getUserBlogs($args)
	{
		return $this->_getUserBlogs($args[1],$args[2]);
	}
	
	function blogger_getPost($args)
	{
		return $this->_getPost($args[2],$args[3],$args[1]);
	}
	
	function blogger_getRecentPosts($args)
	{
		return $this->_getRecentPosts($args[2],$args[3],$args[4]);
	}
	
	function blogger_newPost($args)
	{
		return $this->_newPost($args[2],$args[3],$args[4],$args[5]);
	}
	
	function blogger_editPost($args)
	{
		return $this->_editPost($args[2],$args[3],$args[1],$args[4],$args[5]);
	}
	
	function blogger_deletePost($args)
	{
		return $this->_deletePost($args[2],$args[3],$args[1],1);
	}
	
	# Mthodes B2
	function b2_getCategories($args)
	{
		return $this->_getCategories($args[1],$args[2]);
	}
	
	# Fonctions gnriques
	function _getUserInfo($user,$pwd)
	{
		if ($this->blog->checkUser($user,$pwd,1) === false) {
			return new IXR_Error(801,'Erreur de login');
		}
		
		if (($rs = $this->blog->getUser($user)) === false)
		{
			return new IXR_Error(801,'Erreur de login');
		}
		else
		{
			return array(
				'userid' => $rs->f('user_id'),
				'firstname' => $rs->f('user_prenom'),
				'lastname' => $rs->f('user_nom'),
				'nickname' => $rs->f('user_pseudo'),
				'email' => $rs->f('user_email'),
				'url' => $this->blog_url);
		}
	}
	
	function _getUserBlogs($user,$pwd)
	{
		if ($this->blog->checkUser($user,$pwd,1) === false)
		{
			return new IXR_Error(801,'Erreur de login');
		}
		else
		{
			return array(array(
				'url' => $this->blog_url,
				'blogid' => '1',
				'blogName' => $this->blog_name
				));
		}
	}
	
	function _getCategories($user,$pwd)
	{
		if ($this->blog->checkUser($user,$pwd,1) === false) {
			return new IXR_Error(801,'Erreur de login');
		}
		
		if (($rs = $this->blog->getCat()) === false)
		{
			return new IXR_Error(802,'Erreur SQL');
		}
		else
		{
			$res = array();
			while (!$rs->EOF())
			{
				$res[] = array(
					'categoryId' => $rs->f('cat_id'),
					'categoryName' => $rs->f('cat_libelle')
					);
				$rs->moveNext();
			}
			return $res;
		}
	}
	
	function _getPost($user,$pwd,$postid)
	{
		if ($this->blog->checkUser($user,$pwd,1) === false) {
			return new IXR_Error(801,'Erreur de login');
		}
		
		if(empty($postid)) {
			return new IXR_Error(806,'Pas de billet pour cet ID');
		}
		
		$rs = $this->blog->getPostByID($postid);
		
		if($rs->isEmpty()) {
			return new IXR_Error(806,'Pas de billet pour cet ID');
		}
		
		$content = '<category>'.$rs->f('cat_id').'</category>'."\n".
				'<title>'.$rs->f('titre').'</title>'."\n".
				$rs->f('content');
		
		return array(
			'content' => $content,
			'userId' => $rs->f('user_id'),
			'postId' => $rs->f('post_id'),
			'dateCreated' => new IXR_Date(gmdate("Ymd", $rs->getTS())."T".
							gmdate("H:i:s", $rs->getTS()))
			);
	}
	
	function _getRecentPosts($user,$pwd,$numberofposts)
	{
		if ($this->blog->checkUser($user,$pwd,1) === false) {
			return new IXR_Error(801,'Erreur de login');
		}
		
		if($numberofposts > 20) {
			return new IXR_Error(805,'Ne peut obtenir plus de 20 billets');
		}
		
		$this->blog->setUser($user);
		
		if (($news = $this->blog->getLastNews($numberofposts)) === false)
		{
			return new IXR_Error(802,'Erreur MySQL');
		}
		else
		{
			$res = array();
			while (!$news->EOF())
			{
				$content = '<category>'.$news->f('cat_id').'</category>'."\n".
				'<title>'.$news->f('post_titre').'</title>'."\n".
				$news->f('post_content');
				
				$res[] = array(
					'content' => $content,
					'userId' => $news->f('user_id'),
					'postId' => $news->f('post_id'),
					'dateCreated' => new IXR_Date(gmdate('Ymd', $news->getTS()).
								'T'.gmdate('H:i:s', $news->getTS()))
					);
				$news->moveNext();
			}
			return $res;
		}
	}
	
	function _newPost($user,$pwd,$content,$publish)
	{
		if ($this->blog->checkUser($user,$pwd,1) === false) {
			return new IXR_Error(801,'Erreur de login');
		}
		
		if (empty($content)) {
			return new IXR_Error(804,'Impossible de crer un billet vide');
		}
		
		$rsUser = $this->blog->getUser($user);
		
		$publish = (boolean) $publish;
		
		preg_match('/<title>(.*?)<\/title>/ms',$content,$match);
		$titre = (!empty($match[1])) ? trim($match[1]) : ' - ';
		$content = preg_replace('/<title>(.*?)<\/title>/ms','',$content);
		
		//Rcupration puis suppression de la catgorie
		preg_match('/<category>(.*?)<\/category>/ms',$content,$match);
		$cat_id = (!empty($match[1])) ? trim($match[1]) : NULL;
		$content = preg_replace('/<category>(.*?)<\/category>/ms','',$content);
		
		if ($cat_id === NULL || !$this->blog->checkCat($cat_id)) {
			$cat_id = $rsUser->f('user_pref_cat');
		}
		
		if ($this->blog->addPost($user,$titre,$content,$cat_id,'html',$publish,true) !== false) {
			return $this->blog->con->getLastID();
		} else {
			return new IXR_Error(802,'Erreur MySQL');
		}
	}
	
	function _editPost($user,$pwd,$postid,$content,$publish)
	{
		if ($this->blog->checkUser($user,$pwd,1) === false) {
			return new IXR_Error(801,'Erreur de login');
		}
		
		if (empty($content)) {
			return new IXR_Error(804,'Impossible de crer un billet vide');
		}
		
		$rsUser = $this->blog->getUser($user);
		
		$rsPost = $this->blog->getPostByID($postid);
		
		if ($user != $rsPost->f('user_id') && $rsUser->f('user_level') < 9) {
			return new IXR_Error(807,'Permissions insuffisantes');
		}
		
		$opencomment = $rsPost->f('post_open_comment');
		
		$publish = (boolean) $publish;
		
		preg_match('/<title>(.*?)<\/title>/ms',$content,$match);
		$titre = (!empty($match[1])) ? trim($match[1]) : ' - ';
		$content = preg_replace('/<title>(.*?)<\/title>/ms','',$content);
		
		//Rcupration puis suppression de la catgorie
		preg_match('/<category>(.*?)<\/category>/ms',$content,$match);
		$cat_id = (!empty($match[1])) ? trim($match[1]) : NULL;
		$content = preg_replace('/<category>(.*?)<\/category>/ms','',$content);
		
		if ($cat_id === NULL || !$this->blog->checkCat($cat_id)) {
			$cat_id = $rsUser->f('user_pref_cat');
		}
		
		if ($this->blog->updPost($postid,$titre,$content,$cat_id,'html',$publish,$opencomment) !== false) {
			return true;
		} else {
			return new IXR_Error(802,'Erreur MySQL');
		}
	}
	
	function _deletePost($user,$pwd,$postid,$publish)
	{
		if ($this->blog->checkUser($user,$pwd,1) === false) {
			return new IXR_Error(801,'Erreur de login');
		}
		
		$rsUser = $this->blog->getUser($user);
		
		$rsPost = $this->blog->getPostByID($postid);
		
		if ($user != $rsPost->f('user_id') && $rsUser->f('user_level') < 9) {
			return new IXR_Error(807,'Permissions insuffisantes');
		}
		
		if ($publish) {
			if ($this->blog->delPost($postid) !== false) {
				return true;
			} else {
				return new IXR_Error(802,'Erreur MySQL');
			}
		}
	}
}
?>