<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Nicky Duong.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
# Olivier Meunier
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

class autodiscover
{
	/*
	 * Produit un tableau contenant la liste des permaliens contenus dans un texte.
	 *
	 * @param	String		$text	texte le texte  parser.
	 * @return	String[]			tableaux contenant la liste des URI contenues dans le texte.
	 */
	function getPermaLinksFromText($text)
	{
		$linkArray = array();

		
		if (preg_match_all('/<a ([^>]+)>/ms', $text, $array, PREG_SET_ORDER))
		{
			for ($i = 0; $i<count($array); $i++)
			{
				preg_match('/href="http:\/\/([^"]+)"/ms', $array[$i][1], $matches);
				$linkArray[$matches[1]] = 1;
			}
		}
		
		return array_keys($linkArray);
	}

	/*
	 * Cherche, si il y en a un, le RDF li  une URI.
	 *
	 * @param	String	$link	Permalien
	 * @return	String			Informations RDF
	 */
	function getRDFFromLink($link)
	{
		$pageContents = HttpClient::quickGet('http://'.$link);
		preg_match_all('/(<rdf:RDF.*?<\/rdf:RDF>)/sm', $pageContents, $rdf_all, PREG_SET_ORDER);
		
		for ($i=0; $i<count($rdf_all); $i++)
		{
			if (preg_match('|dc:identifier="http://'.preg_quote($link).'"|ms',$rdf_all[$i][1])) {
				return $rdf_all[$i][1];
			}
		}
		return false;
	}
	
	/*
	 * Trouve la valeur de l'attribut pass en paramtre dans une information RDF.
	 *
	 * @param	String	$RDFInfo	Informations RDF
	 * @param	String	$attribute	Atrribut
	 * @return	String				TrackBack URL
	 */
	function getURIFromRDF($rdf, $attribute)
	{
		if (preg_match('/'.$attribute.'="([^"]+)"/', $rdf, $matches)) {
			return $matches[1];
		}
		return false;
	}

	function autoDiscovery($text)
	{
		$uriArray = $this->getPermaLinksFromText($text);
		$res = array();
		
		for ($i=0;$i<count($uriArray);$i++)
		{
			if (($infoRDF = $this->getRDFFromLink($uriArray[$i])) !== false)
			{
				if (($tburi = $this->getURIFromRDF($infoRDF, 'trackback:ping')) !== false)
				{
					$res[] = $tburi;
				}
			}
		}
		
		return $res;
	}
}
?>