<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

class blogpost extends recordset
{
	function setBlog(&$blog)
	{
		$this->blog = $blog;
	}
	
	# Format du billet
	function getFormat()
	{
		return ($this->f('post_content_wiki') != '') ? 'wiki' : 'html';
	}
	
	# Nombre de commentaires d'un billet
	function getNbComments()
	{
		return (integer) $this->blog->getNbComments($this->f('post_id'));
	}
	
	# Timestamp UNIX du billet
	function getTS()
	{
		return strtotime($this->f('post_dt'));
	}
	
	# Date litrale
	function getLDate()
	{
		return strftime($this->blog->date_format,$this->getTS());
	}
	
	# Heure litrale
	function getLTime()
	{
		return strftime($this->blog->time_format,$this->getTS());
	}
	
	# Date format ISO
	function getIsoDate()
	{
		return date('Y-m-d\\TH:i:s+00:00',$this->getTS());
	}
	
	# Common Name (cn) de l'auteur
	function getUserCN()
	{
		if($this->f('user_pseudo') != '') {
			return $this->f('user_pseudo');
		} else {
			return trim($this->f('user_prenom').' '.$this->f('user_nom'));
		}
	}
	
	# Titre 'URLis'
	function getTitreURL()
	{
		return $this->blog->str2url($this->f('post_titre'));
	}
	
	# Titre de catgorie 'URLis'
	function getCatTitreURL()
	{
		return $this->blog->str2url($this->f('cat_libelle'));
	}
	
	# URL permanente
	function getPermURL()
	{
		return sprintf($this->blog->front_url['post'],$this->f('postyear'),
					$this->f('postmonth'),$this->f('postday'),
					$this->f('post_id'),$this->getTitreURL());
	}
	
	# URL vers la catgorie d'un billet
	function getCatURL()
	{
		return sprintf($this->blog->front_url['cat'],$this->f('cat_libelle_url'));
	}
	
	# Obtenir les id avec une ventuelle chane devant
	function getIDs($str='')
	{
		$res = array();
		
		$index = $this->int_index;
		$this->moveStart();
		
		while (!$this->EOF())
		{
			$res[] = $str.$this->f('post_id');
			$this->moveNext();
		}
		$this->move($index);
		return $res;
	}
}
?>