<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';
require dirname(__FILE__).'/../inc/incutio/class.httpClient.php';

auth(1);
include dirname(__FILE__).'/inc/connexion.php';

include dirname(__FILE__).'/inc/_pop_top.php';

$post_id = (!empty($_GET['post_id'])) ? $_GET['post_id'] : '';

if ($post_id != '') {
	$post = $blog->getPostByID($post_id);
}

?>

<h2>Validation du billet</h2>

<?php
if (empty($post) || $post->isEmpty())
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.
		'<p>Aucun billet</p></div>';
}
else
{
	flush();
	$http = new HttpClient('www.htmlhelp.com',80);
	$http->setUserAgent('Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.3a) Gecko/20021207');
	$http->useGzip(false);
	$http->setPersistReferers(false);
	
	//$http->setDebug(true);
	/*
	POST /cgi-bin/validate.cgi
	charset : UTF-8
	warnings : yes
	input : yes 
	*/
	
	$chapo = utf8_encode($post->f('post_chapo'));
	$content = utf8_encode($post->f('post_content'));
	
	$post_content = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" '.
	'"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">'."\n".
	'<html xmlns="http://www.w3.org/1999/xhtml">'."\n".
	'<head>'."\n".
	'<title>validation</title>'."\n".
	'</head>'."\n".
	'<body>'."\n".
	$chapo."\n".
	$content."\n".
	'</body>'."\n".
	'</html>';
	
	$params = array('area' => $post_content,'charset' => 'UTF-8');
	
	if ($http->post('/cgi-bin/validate.cgi',$params) !== false)
	{
		$result = $http->getContent();
	
		if (strpos($result,'<p class=congratulations><strong>Congratulations, no errors!</strong></p>'))
		{
			echo '<h3>Billet valide.</h3>';
		}
		else
		{
			echo '<h3>Billet invalide.</h3>';
			if ($errors = preg_match('#<h2>Errors</h2>[\s]*(<ul>.*</ul>)#msU',$result,$matches))
			{
				echo '<p>Liste des erreurs&nbsp;:</p>';
				echo strip_tags($matches[1],'<ul><li><pre><b>');
			}
		}
	}
	else
	{
		echo '<p>Impossible de se connecter au serveur.</p>';
	}
	
	echo '<p class="small">Validation effectue par le WDG HTML Validator.<br />'.
	'http://www.htmlhelp.com/tools/validator/</p>';
	echo '<p><img src="images/wdglogo-small.gif" alt="" /></p>';
}
?>



<?php include dirname(__FILE__).'/inc/_pop_bottom.php'; ?>