<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

auth(1);
include dirname(__FILE__).'/inc/connexion.php';

$err = '';

# Tableau des formats
$arry_format = array('HTML' => 'html', 'Wiki' => 'wiki');

# Rcupration des catgories
$rsCat = $blog->getCat();

$arry_cat = array();
while (!$rsCat->EOF())
{
	$arry_cat[htmlspecialchars($rsCat->f('cat_libelle'))] = $rsCat->f('cat_id');
	$rsCat->moveNext();
}

# Rcupration de l'utilisateur
$rs = $blog->getUser($_SESSION['sess_user_id']);

$user_nom = $rs->f('user_nom');
$user_prenom = $rs->f('user_prenom');
$user_pseudo = $rs->f('user_pseudo');
$user_email = $rs->f('user_email');
$user_pwd = '';
$user_post_format = $rs->f('user_post_format');
$user_edit_size = $rs->f('user_edit_size');
$user_pref_cat = $rs->f('user_pref_cat');

# Mise  jour des prfrences
if(!empty($_POST))
{
	$user_prenom = $_POST['user_prenom'];
	$user_nom = $_POST['user_nom'];
	$user_pseudo = $_POST['user_pseudo'];
	$user_email = $_POST['user_email'];
	$user_pwd = trim($_POST['user_pwd']);
	$user_post_format = $_POST['user_post_format'];
	$user_edit_size = $_POST['user_edit_size'];
	$user_pref_cat = $_POST['user_pref_cat'];
	
	if($blog->updUser($_SESSION['sess_user_id'],$_SESSION['sess_user_id'],
	$rs->f('user_level'),$user_pwd,$user_nom,$user_prenom,$user_pseudo,
	$user_email,$user_post_format,$user_edit_size,$user_pref_cat) !== false)
	{
		# On update la session pour que les modifs soient prises en compte
		# tout de suite
		$_SESSION['sess_user_nom'] = $user_nom;
		$_SESSION['sess_user_prenom'] = $user_prenom;
		$_SESSION['sess_user_pseudo'] = $user_pseudo;
		$_SESSION['sess_user_email'] = $user_email;
		$_SESSION['sess_user_format'] = $user_post_format;
		$_SESSION['sess_user_edit_size'] = $user_edit_size;
		$_SESSION['sess_user_pref_cat'] = $user_pref_cat;
		
		if($_SESSION['sess_user_pseudo'] != '')
			$_SESSION['sess_user_cn'] = $_SESSION['sess_user_pseudo'];
		else
			$_SESSION['sess_user_cn'] = trim($_SESSION['sess_user_prenom'].' '.$_SESSION['sess_user_nom']);
		
		$msg = 'Modifications effectues.';
		header('Location: user_prefs.php?msg='.rawurlencode($msg));
		exit;
	} else {
		$err = $blog->error(1);
	}
}

# Sous menu
include dirname(__FILE__).'/inc/_top.php';

if($err != '')
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.$err.'</div>';
}
?>

<h2>Prfrences utilisateur</h2>

<form action="user_prefs.php" method="post">

<p class="field"><label class="float" for="user_prenom">Prnom (facultatif)&nbsp;:</label>
<?php echo php_f_textField('user_prenom',30,255,$user_prenom); ?>
</p>

<p class="field"><label class="float" for="user_nom"><strong>Nom&nbsp;:</strong></label>
<?php echo php_f_textField('user_nom',30,255,$user_nom); ?>
</p>

<p class="field"><label class="float" for="user_pseudo">Pseudo (facultatif)&nbsp;:</label>
<?php echo php_f_textField('user_pseudo',30,255,$user_pseudo); ?>
</p>

<p class="field"><label class="float" for="user_email">Adresse email (facultatif)&nbsp;:</label>
<?php echo php_f_textField('user_email',30,255,$user_email); ?>
</p>

<p class="field"><label class="float" for="user_pwd">Mot de passe&nbsp;:</label>
<?php echo php_f_textField('user_pwd',30,255); ?>
<br />(laissez vide pour ne pas changer le mot de passe)</p>

<p class="field"><label class="float" for="user_post_format"><strong>Format d'dition
prfr&nbsp;:</strong></label>
<?php echo php_f_comboBox('user_post_format',$arry_format,$user_post_format); ?>
</p>

<p class="field"><label class="float" for="user_pref_cat"><strong>Catgorie
prfre&nbsp;:</strong></label>
<?php echo php_f_comboBox('user_pref_cat',$arry_cat,$user_pref_cat); ?>
</p>

<p class="field"><label class="float" for="user_edit_size"><strong>Hauteur de la zone
d'dition de billet&nbsp;:</strong></label>
<?php echo php_f_textField('user_edit_size',2,3,$user_edit_size); ?>
</p>

<p class="field"><input class="submit" type="submit" value="ok" /></p>
</form>

<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>