<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';
require dirname(__FILE__).'/../inc/lib.image.php';
require dirname(__FILE__).'/../inc/class.lum.php';

auth(1);

$err = array();
$up_dir = $_SERVER['DOCUMENT_ROOT'].'/'.$cf_img_url;
$is_writable = false;
$mode = (!empty($_REQUEST['mode'])) ? $_REQUEST['mode'] : '';

$env = (!empty($_GET['env'])) ? $_GET['env'] : 1;

# On vrifie si le rpertoire existe et est accessible en criture
if(is_dir($up_dir))
{
	if (is_writable($up_dir)) {
		$is_writable = true;
	} else {
		$err[] = 'Le rpertoire <strong>'.$cf_img_url.'</strong> n\'est '.
		'pas accessible en criture. Vrifiez les permissions.';
	}
}
else
{
	$err[] = 'Le rpertoire <strong>'.$cf_img_url.'</strong> n\'existe pas.';
}

# Modification d'une image
if (!empty($_GET['img']) && empty($err))
{
	$img_file = str_replace('..','',$_GET['img']);
	$img_file = $img_file;
	
	if (!file_exists($up_dir.'/'.$img_file))
	{
		$err[] = 'L\'image demande n\'existe pas.';
	}
	else
	{
		if (!empty($_GET['del']) && $_GET['del'] == 1)
		{
			if (@unlink($up_dir.'/'.$img_file) === false)
			{
				$err[] = 'Impossible de supprimer l\'image.';
			}
			else
			{
				@unlink($up_dir.'/thumb/'.md5($img_file).'.jpg');
				
				$msg = 'Image supprime avec succs';
				header('Location: uploadimg.php?msg='.rawurlencode($msg).'&mode='.$mode);
				exit();
			}
		}
		elseif(!empty($_GET['thumb']) && $_GET['thumb'] == 1)
		{
			$thumb = $up_dir.'/thumb/'.md5($img_file).'.jpg';
			@$thumb=cropImg($up_dir.'/'.$img_file, $thumb, 100);
		}
	}
}

# Upload de l'image
if($is_writable && !empty($_FILES['up_img']) && empty($err))
{
	$tmp_file = $_FILES['up_img']['tmp_name'];
	$img_name = $_FILES['up_img']['name'];
	
	if (version_compare(phpversion(),'4.2.0','>=')) {
		$upd_error = $_FILES['up_img']['error'];
	} else {
		$upd_error = 0;
	}
	
	if($upd_error != 0)
	{
		switch ($upd_error) {
			case 1:
			case 2:
				$err[] = 'La taille du fichier dpasse la limite autorise';
				break;
			case 3:
				$err[] = 'Le fichier n\'a pas t transfr en entier.';
				break;
			case 4:
				$err[] = 'Aucun fichier';
				break; 
		}
	}
	elseif(filesize($tmp_file) > $max_upload_size)
	{
		$err[] = 'La taille du fichier dpasse la limite autorise'; 
	}
	else
	{	
		if(!getimagesize($tmp_file))
		{
			$err[] = 'Le fichier <strong>'.$img_name.'</strong> n\'est pas une image.';
		}
		else
		{
			if(@copy($tmp_file,$up_dir.'/'.$img_name))
			{
				# On fait le thumbnail
				$thumb = $up_dir.'/thumb/'.md5($img_name).'.jpg';
				@$thumb=cropImg($up_dir.'/'.$img_name, $thumb, 100);
				
				$msg = 'Image transfre avec succs';
				header('Location: uploadimg.php?msg='.rawurlencode($msg).'&mode='.$mode);
				exit();
			}
			else
			{
				$err[] = 'Une erreur s\'est produite lors du transfert de l\'image.';
			}
		}
	}
}

if ($mode == 'popup') {
	include dirname(__FILE__).'/inc/_pop_top.php';
} else {
	# Sous menu
	$mySubMenu->addItem(
		'Retour  la liste des billets','index.php','images/ico_retour.png',false);
	
	include dirname(__FILE__).'/inc/_top.php';
}

echo '<h2>Gestion des images</h2>';

if (count($err) > 0)
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.
		'<ul><li>'.implode('</li><li>',$err).'</li></ul></div>';
}
?>

<?php if($is_writable) : ?>
<h3>Transfrer une image</h3>
<form enctype="multipart/form-data" action="uploadimg.php" method="post">

<p><label for="up_img">Choisissez un fichier
(taille maximum de <?php echo my_size($max_upload_size); ?>)&nbsp;: </label>
<input name="up_img" id="up_img" type="file" /></p>
<input type="hidden" name="MAX_FILE_SIZE" value="<?php echo $max_upload_size; ?>" />
<input type="hidden" name="mode" value="<?php echo $mode; ?>" />
<p><input class="submit" type="submit" value="envoyer" /></p>
</form>

<h3>Vos images</h3>
<?php
$D = dir($up_dir);

$img_list = array();
$i = 0;
while(false !== ($entry = $D->read()))
{
	if($entry != '.' && $entry != '..' && !is_dir($up_dir.'/'.$entry)) {
		 $img_list[$i]['url'] = $cf_img_url.$entry;
		 $img_list[$i]['name'] = $entry;
		 $i++;
	}
}

# Ligne pour afficher l'image
function ligne_image($data,$i)
{
	global $mode, $up_dir, $cf_img_url;
	
	$url = $data['url'];
	$name = $data['name'];
	
	$res = '<div class="ligne">';
		
	if ($mode == 'popup')
	{
		$action_link = '<a href="#" '.
		'onclick="insertImage(window.opener.document,\''.$url.'\'); '.
		'window.close(); return false;">%s</a>';
	}
	else
	{
		$action_link = '<a href="'.$url.'">%s</a>';
	}
	
	if (file_exists($up_dir.'/thumb/'.md5($name).'.jpg'))
	{
		$th = sprintf($action_link,
			'<img class="thumbnail" '.
			'src="'.$cf_img_url.'/thumb/'.md5($name).'.jpg" alt="" />');
	}
	else
	{
		$th = 'Pas de miniature. - '.
		'<a href="uploadimg.php?img='.rawurlencode($name).
		'&amp;thumb=1&amp;mode='.$mode.'">'.
		'Essayer de faire la miniature</a>';
	}
	
	$res .= '<p class="small">'.$th.'</p>'.
			'<p class="small">'.sprintf($action_link,$name).'</a> '.
			'[<strong><a href="uploadimg.php?img='.rawurlencode($name).'&amp;del=1&amp;mode='.$mode.'" '.
			'onclick="return window.confirm(\'Etes vous sr de vouloir supprimer '.
			'cette image ?\')">supprimer</a></strong>]<br /> '.
			'<strong>lien</strong> : '.$url.'</p>'.
			'</div>';
	
	return $res;
}

// Afichage
$objLum = new lum($env,'ligne_image',$img_list,0,5);

$objLum->htmlHeader = '';
$objLum->htmlLineStart = '';
$objLum->htmlColStart = '';
$objLum->htmlColEnd = '';
$objLum->htmlLineEnd = '';
$objLum->htmlFooter = '';

$objLum->htmlLinksStart = '<p class="small">';
$objLum->htmlLinksEnd = '</p>';

$objLum->htmlCurPgStart = '<strong>';
$objLum->htmlCurPgEnd = '</strong>';

$objLum->htmlPrev = '&lt;page prc.';
$objLum->htmlNext = 'page suiv.&gt;';
$objLum->htmlPrevGrp = '...';
$objLum->htmlNextGrp = '...';

$objLum->htmlEmpty = '<p><strong>Aucun fichier actuellement.</strong></p>';

echo $objLum->drawLinks();
echo $objLum->drawPage();
echo $objLum->drawLinks();

?>
<?php endif; ?>

<?php
if ($mode == 'popup') {
	include dirname(__FILE__).'/inc/_pop_bottom.php';
} else {
	include dirname(__FILE__).'/inc/_bottom.php';
}
?>