<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

header('Content-Type: text/plain');

require dirname(__FILE__).'/../conf/config.php';
require dirname(__FILE__).'/../inc/prepend.php';

echo 'Mise  jour de DotClear 1.0rc1 vers 1.0rc2'."\n";

$con = new Connection($dbuser,$dbpass,$dbhost,$dbbase);

if($con->error()) {
	echo 'Impossible de se connecter  la base : '.$con->error()."\n";
	exit;
}

echo "\n----\n";
echo 'Cration de la table '.$dbprefix.'ping.'."\n";

$req="CREATE TABLE ".$dbprefix."ping (".
	"ping_id int(11) NOT NULL auto_increment, ".
	"post_id int(11) NOT NULL default '0', ".
	"ping_url varchar(255) NOT NULL default '0', ".
	"ping_dt datetime default NULL, ".
	"PRIMARY KEY  (ping_id) ".
	") TYPE=MyISAM ";

if($con->execute($req) === false) {
	echo 'Erreur : '.$con->error();
	exit;
} else {
	echo 'Table '.$dbprefix.'ping cre.'."\n";
}


echo "\n----\n";
echo 'Suppression d\'un champ de la table '.$dbprefix.'post.'."\n";

$req="ALTER TABLE ".$dbprefix."post DROP post_gupddt ";

if($con->execute($req) === false) {
	echo 'Erreur : '.$con->error();
	exit;
} else {
	echo 'Table '.$dbprefix.'post mise  jour.'."\n";
}

echo "\n\n";
echo "Votre version de DotClear est mise  jour. Vous pouvez supprimer ce fichier.\n";

$con->close();

?>