<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';
require dirname(__FILE__).'/../inc/incutio/class.httpClient.php';
require dirname(__FILE__).'/../inc/class.dc.autodiscovery.php';

auth(1);
include dirname(__FILE__).'/inc/connexion.php';

$list_url = (!empty($_POST['list_url'])) ? $_POST['list_url'] : '';
$is_editable = false;
$ping_res = array();

$post_id = (!empty($_REQUEST['post_id'])) ? $_REQUEST['post_id'] : '';

# Vrifications d'usage
if ($post_id != '') {
	$post = $blog->getPostByID($post_id);
	
	if (!$post->isEmpty())
	{
		# Post ditable que par un admin ou son crateur
		if ($post->f('user_id') == $_SESSION['sess_user_id'] || $_SESSION['sess_user_level'] >= 9) {
			$is_editable = true;
		}
	}
}

# Cration des trackback
if ($is_editable && $list_url != '')
{
	$list_url = str_replace("\r",'',$list_url);
	$turi = array_unique(explode("\n",$list_url));
	
	foreach ($turi as $uri)
	{
		if ($blog->postTbPingURL($post_id,$uri,$cf_blog_name) !== false) {
			$ping_res[$uri]['status'] = true;
		} else {
			$ping_error = $blog->error();
			$ping_res[$uri]['status'] = false;
			$ping_res[$uri]['error'] = $ping_error[0][1];
			$blog->resetError();
		}
	}
}

# Sous menu
$mySubMenu->addItem(
	'Retour au billet','poster.php?post_id='.$post_id,
	'images/ico_retour.png',false);

include dirname(__FILE__).'/inc/_top.php';
?>

<h2>Ajouter des trackback</h2>

<?php
if (!$is_editable)
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.
		'<p>Aucun billet ou permissions insuffisantes</p></div>';
}
else
{
	$chapo = $post->f('post_chapo');
	$content = $post->f('post_content');
	
	echo '<div class="preview">'.
		'<h3>'.$post->f('post_titre').'</h3>'.
		(($chapo != '') ? $chapo.'<hr class="thin" />' : '').
		$content.'</div>';
	
	if (!empty($_GET['auto']) && $_GET['auto'] == 1)
	{
		$autodisc = new autodiscover();
		$list_url = implode("\n",$autodisc->autoDiscovery($chapo."\n".$content));
	}
	
	echo '<p><a href="trackback.php?post_id='.$post_id.'&auto=1">'.
			'Dcouverte automatique des URL  pinguer.</a></p>';
	
	echo '<form action="trackback.php" method="post">'.
		'<p><label for="list_url">Insrez ici les URL  pinguer, les unes sous '.
		'les autres. :</label>'.
		php_f_textArea('list_url',30,5,
		$list_url,'','style="width:100%"').
		'</p>'.
		'<p><input type="submit" class="submit" value="Faire les trackback" /> '.
		php_f_hidden('post_id',$post_id).
		'</p>'.
		'</form>';
	
	if (!empty($_POST['list_url']))
	{
		echo '<h3>Rsultats</h3>';
		
		foreach ($ping_res as $k => $v)
		{
			if ($v['status']) {
				$img = '<img src="images/check_on.png" alt="OK" />';
			} else {
				$img = '<img src="images/check_off.png" alt="ERREUR" />';
			}
			
			echo '<p>'.$img.' '.$k.'<br />'.
			'<strong>'.((!$v['status']) ? $v['error'] : 'Ping OK').'</strong>';
			'</p>';
		}
	}
	
	echo '<h3>Liste des ping raliss</h3>';
	
	$rs = $blog->postGetPings($post_id);
	
	if ($rs->isEmpty()) {
		echo '<p>Aucun ping pour le moment.</p>';
	} else {
		echo '<ul>';
		while (!$rs->EOF())
		{
			echo '<li>'.
				'['.date('d/m/Y @ H:i:s',strtotime($rs->f('ping_dt'))).'] '.
				'<strong>'.$rs->f('ping_url').'</strong>'.
				'</li>';
			$rs->moveNext();
		}
		echo '</ul>';
	}
}
?>


<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>