<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

$err = '';
$tool_url = '';

# Liste des thmes
$tolls_root = dirname(__FILE__).'/../';
$objPlugins = new plugins($tolls_root);
$tools_list = $objPlugins->getPlugins('plugin',false);

$is_writable = is_writable($tolls_root);

# Installation d'un thme
if ($is_writable && !empty($_GET['tool_url']))
{
	$tool_url = $_GET['tool_url'];
	$parsed_url = parse_url($tool_url);
	
	if (empty($parsed_url['scheme']) || !preg_match('/^http|ftp$/',$parsed_url['scheme'])
	|| empty($parsed_url['host']) || empty($parsed_url['path']))
	{
		$err = 'L\'URL est invalide.';
	}
	else
	{
		if (($err = $objPlugins->install($tool_url)) === true)
		{
			header('Location: tools.php?p=toolsmng');
			exit;
		}
	}
}

# Suppression d'un thme
$delete = (!empty($_GET['delete'])) ? $_GET['delete'] : '';

if ($is_writable && $delete != '' && in_array($delete,array_keys($tools_list)) && $delete != 'default')
{
	deltree($tolls_root.'/'.$delete);
	header('Location: tools.php?p=toolsmng');
	exit;
}

if($err != '')
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.$err.'</div>';
}
?>

<h2>Gestion des plugins</h2>

<h3>Installer un plugin</h3>
<?php
if (!$is_writable)
{
	echo '<p>Le dossier ecrire/tools/ n\'est pas accessible en criture, vrifiez les '.
		'permissions sur celui-ci.</p>';
}
else
{
	echo '<form action="tools.php" method="get">'.
		'<p><label for="tool_url">Indiquez l\'URL (http ou ftp) du fichier de plugin :</label>'.
		php_f_textField('tool_url',50,'',$tool_url).'</p>'.
		'<p><input type="submit" class="submit" value="installer" />'.
		'<input type="hidden" name="p" value="toolsmng" /></p>'.
		'</form>';
	
}
?>

<h3>Liste des plugins installs</h3>
<dl>
<?php
foreach ($tools_list as $k => $v)
{
	echo '<dt>'.$v['label'].' - '.$k.'</dt>';
	echo '<dd>'.$v['desc'].' <br />'.
		'par '.$v['author'].' - version '.$v['version'].' <br />';
	
	if ($k != 'toolsmng') {
		echo '<a href="tools.php?p=toolsmng&amp;delete='.$k.'" '.
		'onclick="return window.confirm(\'tes vous sr de vouloir supprimer ce plugin ?\')">supprimer</a>';
	}
	
	echo '</dd>';
}
?>
</dl>