<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

$err = '';
$theme_url = '';

# Liste des thmes
$themes_root = dirname(__FILE__).'/../../../themes';
$objPlugins = new plugins($themes_root);
$theme_list = $objPlugins->getPlugins('theme',false);

$is_writable = is_writable($themes_root);

# Installation d'un thme
if ($is_writable && !empty($_GET['theme_url']))
{
	$theme_url = $_GET['theme_url'];
	$parsed_url = parse_url($theme_url);
	
	if (empty($parsed_url['scheme']) || !preg_match('/^http|ftp$/',$parsed_url['scheme'])
	|| empty($parsed_url['host']) || empty($parsed_url['path']))
	{
		$err = 'L\'URL est invalide.';
	}
	else
	{
		if (($err = $objPlugins->install($theme_url)) === true)
		{
			header('Location: tools.php?p=thememng');
			exit;
		}
	}
}

# Suppression d'un thme
$delete = (!empty($_GET['delete'])) ? $_GET['delete'] : '';

if ($is_writable && $delete != '' && in_array($delete,array_keys($theme_list)) && $delete != 'default')
{
	deltree($themes_root.'/'.$delete);
	header('Location: tools.php?p=thememng');
	exit;
}

if($err != '')
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.$err.'</div>';
}
?>

<h2>Gestion des thmes</h2>

<h3>Installer un thme</h3>
<?php
if (!$is_writable)
{
	echo '<p>Le dossier themes/ n\'est pas accessible en criture, vrifiez les '.
		'permissions sur celui-ci.</p>';
}
else
{
	echo '<form action="tools.php" method="get">'.
		'<p><label for="theme_url">Indiquez l\'URL (http ou ftp) du fichier de thme :</label>'.
		php_f_textField('theme_url',50,'',$theme_url).'</p>'.
		'<p><input type="submit" class="submit" value="installer" />'.
		'<input type="hidden" name="p" value="thememng" /></p>'.
		'</form>';
	
}
?>

<h3>Liste des thmes installs</h3>
<dl>
<?php
foreach ($theme_list as $k => $v)
{
	echo '<dt>'.$v['label'].' - '.$k.'</dt>';
	echo '<dd>'.$v['desc'].' <br />'.
		'par '.$v['author'].' - version '.$v['version'].' <br />';
	
	if ($k != 'default') {
		echo '<a href="tools.php?p=thememng&amp;delete='.$k.'" '.
		'onclick="return window.confirm(\'tes vous sr de vouloir supprimer ce thme ?\')">supprimer</a>';
	}
	
	echo '</dd>';
}
?>
</dl>