<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****
?>
<h2>Informations</h2>

<h3>Informations gnrales</h3>
<?php
# Version de dotclear
if (file_exists(dirname(__FILE__).'/../../../VERSION')) {
	$dc_version = trim(implode('',file(dirname(__FILE__).'/../../../VERSION')));
	
	echo '<p>Vous utilisez la version <strong>'.$dc_version.'</strong> de DotClear.</p>';
}

# Les tables de la base de donnes
$arry_table = array($blog->t_post,$blog->t_user,$blog->t_categorie,$blog->t_comment,$blog->t_ping);
$rs = $con->select('SHOW TABLE STATUS FROM `'.$dbbase.'`');

echo '<p>Les tables DotClear de votre base de donnes sont : </p>';
echo '<table class="clean-table">';
echo '<tr><th>Nom</th><th>Enregistrements</th><th>Taille</th></tr>';
while (!$rs->EOF())
{
	if (in_array($rs->f('name'),$arry_table)) {
		echo '<tr>';
		echo '<td>'.$rs->f('name').'</td>';
		echo '<td>'.$rs->f('rows').'</td>';
		echo '<td>'.my_size($rs->f('Data_length')+$rs->f('Index_length')).'</td>';
		echo '</tr>';
	}
	
	$rs->moveNext();
}
echo '</table>';
?>

<h3>Informations fichiers</h3>
<p>Droits d'accs de fichiers ou rpertoires. Qu'un fichier ou rpertoire de
cette liste ne soit pas accessible en criture par le serveur Web n'a rien de
bloquant, a peut juste empcher l'usage de certains modules.</p>

<?php $img_check = '<img src="images/check_%s.png" alt="" />'; ?>

<?php
if (is_writable(dirname(__FILE__).'/../../../conf/blog_conf.php')) {
	echo '<p>'.sprintf($img_check,'on').' Le fichier conf/blog_conf.php est '.
		'accessible en criture.</p>';
} else {
	echo '<p>'.sprintf($img_check,'off').' Le fichier conf/blog_conf.php n\'est '.
		'pas accessible en criture.</p>';
}

if (is_writable(dirname(__FILE__).'/../../../conf/UPDATE')) {
	echo '<p>'.sprintf($img_check,'on').' Le fichier conf/UPDATE est '.
		'accessible en criture.</p>';
} else {
	echo '<p>'.sprintf($img_check,'off').' Le fichier conf/UPDATE n\'est '.
		'pas accessible en criture.</p>';
}

if (is_writable($_SERVER['DOCUMENT_ROOT'].$cf_img_url)) {
	echo '<p>'.sprintf($img_check,'on').' Le rpertoire '.$cf_img_url.' est '.
		'accessible en criture.</p>';
} else {
	echo '<p>'.sprintf($img_check,'off').' Le rpertoire '.$cf_img_url.' n\'est '.
		'pas accessible en criture.</p>';
}

if (is_writable(dirname(__FILE__).'/../../../themes')) {
	echo '<p>'.sprintf($img_check,'on').' Le rpertoire themes/ est '.
		'accessible en criture.</p>';
} else {
	echo '<p>'.sprintf($img_check,'off').' Le rpertoire themes/ n\'est '.
		'pas accessible en criture.</p>';
}

if (!defined('DC_UPDATE_FILE_W') || !DC_UPDATE_FILE_W) {
	echo '<p><strong>Important :</strong> votre fichier conf/UPDATE n\'est '.
		'pas accessible en criture. Bien que ceci ne soit pas bloquant, il '.
		'est prfrable de le rendre accessible en criture par votre serveur '.
		'Web afin d\'activer totalement le cache HTTP. Pour rendre un fichier '.
		'accessible en criture, vous pouvez utiliser un client FTP ou demander '.
		' votre hbergeur.';
}
?>



<h3>Informations serveur</h3>

<p>Votre version de PHP est <strong><?php echo phpversion(); ?></strong></p>

<?php
if (($rs = $con->select('SELECT VERSION() AS version')) !== false) {
	$mysql_version = preg_replace('/-log$/','',$rs->f(0));
	echo '<p>Votre version de MySQL est <strong>'.
		preg_replace('/-log$/','',$rs->f(0)).'</strong></p>';
	
	$mysql_version = preg_replace('/-log$/','',$rs->f(0));
}

if (!empty($_SERVER["SERVER_SOFTWARE"])) {
	echo '<p>Votre serveur Web est :<br /> <strong>'.$_SERVER["SERVER_SOFTWARE"].'</strong></p>';
}



?>
