<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/../../../inc/class.configfile.php';

$dc_config_file = dirname(__FILE__).'/../../../conf/blog_conf.php';

# Liste des thmes
$objPlugins = new plugins(dirname(__FILE__).'/../../../themes');
$theme_list = $objPlugins->getPlugins('theme');

$arry_theme = array();
foreach ($theme_list as $kt => $kv)
{
	$arry_theme[$kt] = $kt;
}

$err = '';

$url = 'tools.php?p=blogconf';
$is_writable = false;

if (!is_writable($dc_config_file)) {
	$err = '<p>Le fichier de configuration blog_conf.php n\'est pas '.
	'accessible en criture.</p>';
} else {
	$is_writable = true;
	
	$p_blog_name = $cf_blog_name;
	$p_blog_url = $cf_blog_url;
	$p_img_url = $cf_img_url;
	$p_theme = $cf_theme;
	$p_nb_post_per_page = $cf_nb_post_per_page;
	$p_allow_comments = $cf_allow_comments;
	$p_allow_trackbacks = $cf_allow_trackbacks;
	$p_wiki_comments = $cf_wiki_comments;
	$p_use_smilies = $cf_use_smilies;
	$p_comment_notification = $cf_comment_notification;
	$p_date_format = $cf_date_format;
	$p_time_format = $cf_time_format;
	
	# Modification du fichier
	if (!empty($_POST))
	{
		$p_blog_name = $_POST['p_blog_name'];
		$p_blog_url = $_POST['p_blog_url'];
		$p_img_url = $_POST['p_img_url'];
		$p_theme = $_POST['p_theme'];
		$p_nb_post_per_page = $_POST['p_nb_post_per_page'];
		$p_allow_comments = $_POST['p_allow_comments'];
		$p_allow_trackbacks = $_POST['p_allow_trackbacks'];
		$p_wiki_comments = $_POST['p_wiki_comments'];
		$p_use_smilies = $_POST['p_use_smilies'];
		$p_comment_notification = $_POST['p_comment_notification'];
		$p_date_format = $_POST['p_date_format'];
		$p_time_format = $_POST['p_time_format'];
		
		$p_blog_url = preg_replace('|/+$|','',$p_blog_url);
		$p_blog_url = preg_replace('|^/+|','',$p_blog_url);
		$p_img_url = preg_replace('|/+$|','',$p_img_url);
		$p_img_url = preg_replace('|^/+|','',$p_img_url);
		$p_blog_url = '/'.$p_blog_url.'/';
		$p_img_url = '/'.$p_img_url.'/';
			
		$arry_err = array();
		
		if (trim($p_blog_name) == '') {
			$arry_err[] = 'Vous devez indiquer un nom au blog';
		}
		
		if (trim($p_blog_url) == '') {
			$arry_err[] = 'Vous devez indiquer une url';
		}
		
		if (trim($p_img_url) == '') {
			$arry_err[] = 'Vous devez donner un emplacement pour les images';
		}
		
		if (trim($p_blog_url) == '') {
			$arry_err[] = 'Vous devez donner une url';
		}
		
		if (!preg_match('/^[0-9]+$/',trim($p_nb_post_per_page))) {
			$arry_err[] = 'Vous devez donner un nombre de billets par page valide';
		}
		
		if (count($arry_err) > 0)
		{
			$err .= '<ul>';
			foreach ($arry_err as $v) { $err .= '<li>'.$v.'</li>'; }
			$err .= '</ul>';
		}
		else
		{
			$objConf = new configfile($dc_config_file);
			$objConf->editVar('cf_blog_name',$p_blog_name);
			$objConf->editVar('cf_blog_url',$p_blog_url);
			$objConf->editVar('cf_img_url',$p_img_url);
			$objConf->editVar('cf_theme',$p_theme);
			$objConf->editVar('cf_nb_post_per_page',(integer) $p_nb_post_per_page);
			$objConf->editVar('cf_allow_comments',(integer) $p_allow_comments);
			$objConf->editVar('cf_allow_trackbacks',(integer) $p_allow_trackbacks);
			$objConf->editVar('cf_wiki_comments',(integer) $p_wiki_comments);
			$objConf->editVar('cf_use_smilies',(integer) $p_use_smilies);
			$objConf->editVar('cf_comment_notification',(integer) $p_comment_notification);
			$objConf->editVar('cf_date_format',$p_date_format);
			$objConf->editVar('cf_time_format',$p_time_format);
			
			if ($objConf->saveFile() !== false) {
				header('Location: '.$url.'&done=1');
				exit;
			} else {
				$err = 'Une erreur s\'est produite  l\'criture du fichier';
			}
		}
	}
}

echo '<h2>Configuration de DotClear</h2>';

if($err != '')
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.$err.'</div>';
}

if ($is_writable) {
?>
	<?php
	if (!empty($_GET['done'])) {
		echo '<p class="message">Modifications effectues avec succs.</p>';
	}
	?>
	
	
	<form action="<?php echo $url; ?>" method="post">
	
	<p class="field"><label for="p_blog_name"><strong>Nom du blogue&nbsp;:</strong></label>
	<?php echo php_f_textField('p_blog_name',30,'',htmlspecialchars($p_blog_name)); ?>
	</p>
	
	<p class="field"><label for="p_blog_url"><strong>URL vers le blogue</strong>
	(depuis http://<?php echo $_SERVER['SERVER_NAME']; ?>)&nbsp;:</label>
	<?php echo php_f_textField('p_blog_url',30,512,htmlspecialchars($p_blog_url)); ?>
	</p>
	
	<p class="field"><label for="p_img_url"><strong>Emplacement des images</strong>
	(depuis http://<?php echo $_SERVER['SERVER_NAME']; ?>)&nbsp;:</label>
	<?php echo php_f_textField('p_img_url',30,512,htmlspecialchars($p_img_url)); ?>
	</p>
	
	<p class="field"><label for="p_theme"><strong>Thme&nbsp;:</strong></label>
	<?php echo php_f_combobox('p_theme',$arry_theme,$p_theme); ?>
	</p>
	
	<p class="field"><label for="p_nb_post_per_page"><strong>Nombre de billet par page</strong>
	(premire page et catgories)&nbsp;:</label>
	<?php echo php_f_textField('p_nb_post_per_page',3,'',$p_nb_post_per_page); ?>
	</p>
	
	<p class="field"><label for="p_allow_comments"><strong>Permettre les commentaires&nbsp;:</strong></label>
	<?php echo php_f_combobox('p_allow_comments',array('Oui'=>1,'Non'=>0),$p_allow_comments); ?>
	</p>
	
	<p class="field"><label for="p_allow_trackbacks"><strong>Permettre les trackbacks&nbsp;:</strong></label>
	<?php echo php_f_combobox('p_allow_trackbacks',array('Oui'=>1,'Non'=>0),$p_allow_trackbacks); ?>
	</p>
	
	<p class="field"><label for="p_allow_comments"><strong>Commentaires au format Wiki&nbsp;:</strong></label>
	<?php echo php_f_combobox('p_wiki_comments',array('Oui'=>1,'Non'=>0),$p_wiki_comments); ?>
	</p>
	
	<p class="field"><label for="p_use_smilies"><strong>Afficher des moticones&nbsp;:</strong></label>
	<?php echo php_f_combobox('p_use_smilies',array('Oui'=>1,'Non'=>0),$p_use_smilies); ?>
	</p>
	
	<p class="field"><label for="p_comment_notification"><strong>Notification des commentaires par email&nbsp;:</strong></label>
	<?php echo php_f_combobox('p_comment_notification',array('Oui'=>1,'Non'=>0),$p_comment_notification); ?>
	</p>
	
	<p class="field"><label for="p_date_format"><strong>Format de la date&nbsp;:</strong></label>
	<?php echo php_f_textField('p_date_format',30,'',htmlspecialchars($p_date_format)); ?>
	</p>
	
	<p class="field"><label for="p_time_format"><strong>Format de l'heure&nbsp;:</strong></label>
	<?php echo php_f_textField('p_time_format',30,'',htmlspecialchars($p_time_format)); ?>
	</p>
	
	<p class="field"><input class="submit" type="submit" value="ok" /></p>
	</form>
	
	<h3>Format de la date</h3>
	
	<p>Le format de la date et de l'heure suit les rgles de la fonction
	<a href="http://www.php.net/manual/fr/function.strftime.php">strftime</a>.
	Voici pour rappel la liste des masques possibles&nbsp;:</p>
	
	<ul>
		<li>%a - nom abr&eacute;g&eacute; du jour de la semaine
		(local).</li>
		<li>%A - nom complet du jour de la semaine (local).</li>
		<li>%b - nom abr&eacute;g&eacute; du mois (local).</li>
		<li>%B - nom complet du mois (local).</li>
		<li>%c - repr&eacute;sentation pr&eacute;f&eacute;r&eacute;e pour
		les dates et heures, en local.</li>
		<li>%C - num&eacute;ro de si&egrave;cle (l'ann&eacute;e,
		divis&eacute;e par 100 et arrondie entre 00 et 99)</li>
		<li>%d - jour du mois en num&eacute;rique (intervalle 01 &agrave;
		31)</li>
		<li>%D - identique &agrave; %m/%d/%y</li>
		<li>%e - num&eacute;ro du jour du mois. Les chiffres sont
		pr&eacute;c&eacute;d&eacute;s d'un espace (de ' 1' &agrave;
		'31')</li>
		<li>%h - identique &agrave; %b</li>
		<li>%H - heure de la journ&eacute;e en num&eacute;rique, et sur
		24-heures (intervalle de 00 &agrave; 23)</li>
		<li>%I - heure de la journ&eacute;e en num&eacute;rique, et sur
		12- heures (intervalle 01 &agrave; 12)</li>
		<li>%j - jour de l'ann&eacute;e, en num&eacute;rique (intervalle
		001 &agrave; 366)</li>
		<li>%m - mois en num&eacute;rique (intervalle 1 &agrave; 12)</li>
		<li>%M - minute en num&eacute;rique</li>
		<li>%n - retour  la ligne</li>
		<li>%p - soit `am' ou `pm' en fonction de l'heure absolue, ou en
		fonction des valeurs enregistr&eacute;es en local.</li>
		<li>%r - l'heure au format a.m. et p.m.</li>
		<li>%R - l'heure au format 24h</li>
		<li>%S - secondes en num&eacute;rique</li>
		<li>%t - tabulation</li>
		<li>%T - l'heure actuelle (&eacute;gal &agrave; %H:%M:%S)</li>
		<li>%u - le num&eacute;ro de jour dans la semaine, de 1 &agrave;
		7. (1 repr&eacute;sente Lundi)</li>
		<li>%U - num&eacute;ro de semaine dans l'ann&eacute;e, en
		consid&eacute;rant le premier dimanche de l'ann&eacute;e comme le
		premier jour de la premi&egrave;re semaine.</li>
		<li>%V - le num&eacute;ro de semaine comme d&eacute;fini dans
		l'ISO 8601:1988, sous forme d&eacute;cimale, de 01 &agrave; 53.
		La semaine 1 est la premi&egrave;re semaine qui a plus de 4 jours
		dans l'ann&eacute;e courante, et dont Lundi est le premier
		jour.</li>
		<li>%W - num&eacute;ro de semaine dans l'ann&eacute;e, en
		consid&eacute;rant le premier lundi de l'ann&eacute;e comme le
		premier jour de la premi&egrave;re semaine</li>
		<li>%w - jour de la semaine, num&eacute;rique, avec dimanche =
		0</li>
		<li>%x - format pr&eacute;f&eacute;r&eacute; de
		repr&eacute;sentation de la date sans l'heure</li>
		<li>%X - format pr&eacute;f&eacute;r&eacute; de
		repr&eacute;sentation de l'heure sans la date</li>
		<li>%y - l'ann&eacute;e, num&eacute;rique, sur deux chiffres (de
		00 &agrave; 99)</li>
		<li>%Y - l'ann&eacute;e, num&eacute;rique, sur quatre
		chiffres</li>
		<li>%Z - fuseau horaire, ou nom ou abr&eacute;viation</li>
		<li>%% - un caract&egrave;re `%' litt&eacute;ral</li>
	</ul>
	
<?php
} ?>
<p>&nbsp;</p>
