<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';
require dirname(__FILE__).'/../inc/class.plugins.php';

auth(9);
include dirname(__FILE__).'/inc/connexion.php';

# On fait la liste des plugins
$plugins_root = dirname(__FILE__).'/tools/';

$objPlugins = new plugins($plugins_root);
$plugins_list = $objPlugins->getPlugins();

$include = '';

if (!empty($_REQUEST['p']) && !empty($plugins_list[$_REQUEST['p']])
&& $plugins_list[$_REQUEST['p']]['active'])
{
	$p = $_REQUEST['p'];
	ob_start();
	include $plugins_root.$p.'/index.php';
	$include = ob_get_contents();
	ob_end_clean();
	
	$mySubMenu->addItem(
	'Retour aux outils','tools.php',
	'images/ico_retour.png',false);
}

include dirname(__FILE__).'/inc/_top.php';

if ($include != '')
{	
	echo $include;
}
else
{
	echo '<h2>Outils et plugins</h2>';
	
	if (count($plugins_list) == 0)
	{
		echo '<p>Aucun outil n\'est disponible ou actif</p>';
	}
	else
	{
		echo '<dl class="plugin-list">';
		foreach ($plugins_list as $pname => $pdesc)
		{
			echo '<dt>';
			if (file_exists($plugins_root.$pname.'/icon.png')) {
				echo '<img alt="" src="tools/'.$pname.'/icon.png" /> ';
			}
			echo '<a href="tools.php?p='.$pname.'">';
			
			if (!empty($pdesc['label'])) {
				echo $pdesc['label'];
			} else {
				echo $pdesc['name'];
			}
			echo '</a>';
			echo '</dt>';
			
			echo '<dd>'.$pdesc['desc'].'</dd>';
		}
		echo '</dl>';
	}
}
?>


<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>