<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

auth(9);
include dirname(__FILE__).'/inc/connexion.php';

$id = (!empty($_REQUEST['id'])) ? $_REQUEST['id'] : NULL;

$page_titre = 'Cration d\'un utilisateur';

$err = '';
$alert = '';

$user_id = '';
$user_nom = '';
$user_prenom = '';
$user_email = '';
$user_pwd = '';
$user_level = 1;

$arry_levels = array('Dsactiv' => 0,
				'Rdacteur' => 1,
				'Rdacteur avanc' => 5,
				'Administrateur' => 9);

if (!empty($id) || !empty($_POST['user_id']))
{
	if (!empty($id))
	{
		$rsUser = $blog->getUser($id);
		
		if (!$rsUser->isEmpty()) {
			$user_id = $rsUser->f('user_id');
			$user_nom = $rsUser->f('user_nom');
			$user_prenom = $rsUser->f('user_prenom');
			$user_email = $rsUser->f('user_email');
			$user_level = $rsUser->f('user_level');
			
			$page_titre = 'Modification de '.$user_prenom.' '.$user_nom;
			
			if($user_id == $_SESSION['sess_user_id']) {
				$alert = 'Attention, vous allez modifier votre profil.'.
				'Vous serez dconnect aprs les changements.';
			}
			
			# Suppresion d'un rdacteur
			if(!empty($_GET['del']))
			{
				if ($blog->delUser($user_id) !== false) {
					$msg = 'Rdacteur supprim';
					header('Location: redac_list.php?msg='.rawurlencode($msg));
					exit;
				} else {
					$err = $blog->error(1);
				}
			}
			
			# Mise  jour d'un rdacteur
			if(!empty($_POST['user_id']))
			{
				$new_user_id = $_POST['user_id'];
				$user_nom = $_POST['user_nom'];
				$user_prenom = $_POST['user_prenom'];
				$user_email = $_POST['user_email'];
				$user_level = $_POST['user_level'];
				$user_pwd = $_POST['user_pwd'];
				$user_pseudo = $rsUser->f('user_pseudo');
				$user_post_format = $rsUser->f('user_post_format');
				$user_edit_size = $rsUser->f('user_edit_size');
				$user_pref_cat = $rsUser->f('user_pref_cat');
				
				if($blog->updUser($user_id,$new_user_id,$user_level,$user_pwd,
				$user_nom,$user_prenom,$user_pseudo,$user_email,
				$user_post_format,$user_edit_size,$user_pref_cat) !== false)
				{				
					if($user_id == $_SESSION['sess_user_id']) {
						header('Location: index.php?logout=1');
						exit;
					}
					
					$msg = 'Rdacteur modifi avec succs';
					header('Location: redac_list.php?msg='.rawurlencode($msg));
					exit;
				} else {
					$err = $blog->error(1);
				}
				
			}
		}
	}
	elseif(!empty($_POST['user_id']))
	{
		# Cration d'un rdacteur
		$user_id = $_POST['user_id'];
		$user_nom = $_POST['user_nom'];
		$user_prenom = $_POST['user_prenom'];
		$user_email = $_POST['user_email'];
		$user_level = $_POST['user_level'];
		$user_pwd = $_POST['user_pwd'];
	
		if ($blog->addUser($user_id,$user_level,$user_pwd,$user_nom,$user_prenom,
		'',$user_email) !== false ) {
			$msg = 'Rdacteur cr avec succs';
			header('Location: redac_list.php?msg='.rawurlencode($msg));
			exit;
		} else {
			$err = $blog->error(1);
		}
	}
}

include dirname(__FILE__).'/inc/_top.php';

if($err != '')
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.
		$err.'</div>';
}
?>

<p><strong><a href="redac_list.php">retour  la liste des rdacteurs</a></strong></p>
<h2><?php echo $page_titre; ?></h2>

<?php
if ($alert != '') {
	echo '<p class="message">'.$alert.'</p>';
}
?>

<form action="redacteur.php" method="post">

<p>Note : l'identifiant ne doit contenir que des caratres alphanumriques.</p>

<p class="field"><label class="float" for="user_id"><strong>Identifiant&nbsp;:</strong></label>
<?php echo php_f_textField('user_id',30,32,$user_id); ?>
</p>

<p class="field"><label class="float" for="user_prenom">Prnom (facultatif)&nbsp;:</label>
<?php echo php_f_textField('user_prenom',30,255,$user_prenom); ?>
</p>

<p class="field"><label class="float" for="user_nom"><strong>Nom&nbsp;:</strong></label>
<?php echo php_f_textField('user_nom',30,255,$user_nom); ?>
</p>

<p class="field"><label class="float" for="user_email">Adresse email (facultatif)&nbsp;:</label>
<?php echo php_f_textField('user_email',30,255,$user_email); ?>
</p>

<p class="field"><label class="float" for="user_pwd">Mot de passe&nbsp;:</label>
<?php echo php_f_textField('user_pwd',30,255,'');
if ($user_id) { echo '<br />(laissez vide pour ne pas changer le mot de passe)'; }
?></p>

<p class="field"><label class="float" for="user_level"><strong>Niveau&nbsp;:</strong></label>
<?php echo php_f_comboBox('user_level',$arry_levels,$user_level); ?>
</p>

<p class="field"><input class="submit" type="submit" value="ok" />
<?php
echo (!empty($id)) ? '<input type="hidden" name="id" value="'.$id.'" />' : '';
?></p>
</form>

<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>
