<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

auth(9);
include dirname(__FILE__).'/inc/connexion.php';

$mySubMenu->addItem('<strong>Nouveau rdacteur</strong>','redacteur.php','images/ico_new.png',false);

include dirname(__FILE__).'/inc/_top.php';
?>
<h2>Liste des rdacteurs</h2>

<?php

$rsUser = $blog->getUser();

while(!$rsUser->EOF())
{
	$user_level = $rsUser->field('user_level');
	$user_nb_post = $rsUser->field('nb_post');
		
	if ($user_level == 9) {
		$user_level = 'administrateur';
	} elseif ($user_level == 5) {
		$user_level = 'rdacteur avanc';
	} elseif ($user_level == 1) {
		$user_level = 'rdacteur';
	} elseif ($user_level == 0) {
		$user_level = 'dsactiv';
	}
	
	$style = ($rsUser->f('user_level') == 0) ? ' style="color:#999;"' : '';
	
	echo '<div class="ligne"'.$style.'><p>'.
		'<strong>'.$rsUser->field('user_id').'</strong><br />'.
		$rsUser->field('user_prenom').' '.$rsUser->field('user_nom').
		' ('.$user_level.')'.
		' [ <strong><a href="redacteur.php?id='.rawurlencode($rsUser->field('user_id')).'">'.
		'diter</a></strong> - ';
	
	if ($user_nb_post > 0) {
		echo $user_nb_post.' billet';
		echo ($user_nb_post > 1) ? 's' : '';
	} else {
		echo '<a href="redacteur.php?id='.rawurlencode($rsUser->field('user_id')).'&amp;del=1"'.
		'onclick="return window.confirm(\'Etes vous sr de vouloir supprimer '.
		'cet utilisateur ?\')">supprimer</a>';
	}
	
	echo ' ]</p></div>';
	
	$rsUser->moveNext();
}

?>

<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>
