<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

auth(1);
include dirname(__FILE__).'/inc/connexion.php';

# Tableau des mois de l'anne
for ($i=1;$i<=12;$i++) {
	$m = sprintf('%02d',$i);
	$arry_dt_m[strftime('%B',strtotime('2000-'.$m.'-01'))] = $m;
}

# Les catgories du blog
$cat_id = (!empty($_GET['cat_id'])) ? $_GET['cat_id'] : '';

$rsCat = $blog->getCat();
while (!$rsCat->EOF())
{
	$arry_cat[$rsCat->f('cat_libelle')] = $rsCat->f('cat_id');
	$rsCat->moveNext();
}

# Valeurs par dfaut
$err = '';
$titre = '';
$cat_id = $_SESSION['sess_user_pref_cat'];
$dt_m = $dt_d = $dt_y = '';
$chapo = $preview_chapo = '';
$content = $preview_content = '';
$is_editable = true;
$format = $_SESSION['sess_user_format'];
$etat = 1;
$open_comment = 1;
$return_link = 'index.php';

$objWiki = new wiki2xhtml();

# Billet existant
if (!empty($_REQUEST['post_id']))
{
	$post = $blog->getPostById($_REQUEST['post_id']);
	if (!$post->isEmpty())
	{
		$post_id = $post->f('post_id');
		$titre = $post->f('post_titre');
		$cat_id = $post->f('cat_id');
		$format = $post->getFormat();
		$etat = (integer) $post->f('post_pub');
		$open_comment = (integer) $post->f('post_open_comment');
		$chapo = ($post->f('post_chapo_wiki') != '') ? $post->f('post_chapo_wiki') : $post->f('post_chapo');
		$preview_chapo = $post->f('post_chapo');
		$content = ($post->f('post_content_wiki') != '') ? $post->f('post_content_wiki') : $post->f('post_content');
		$preview_content = $post->f('post_content');
		$return_link = 'index.php?m='.$post->f('postyear').$post->f('postmonth').'#p'.$post_id;
		$post_ts = $post->getTS();
		$dt_y = date('Y',$post_ts);
		$dt_m = date('m',$post_ts);
		$dt_d = date('d',$post_ts);
		$dt_h = (string) date('H',$post_ts);
		$dt_i = (string) date('i',$post_ts);
		$dt_s = (string) date('s',$post_ts);
		
		$comments = $blog->getComments($post_id);
		
		# Le post n'est ditable que par un admin ou son rdacteur,
		# qu'on se le dise !
		if ($post->f('user_id') != $_SESSION['sess_user_id'] && $_SESSION['sess_user_level'] < 9) {
			$is_editable = false;
		}
		
		# Changement du status ou suppression d'un commentaire
		if (!empty($_GET['comment_id']))
		{
			if ($is_editable) {
				if (!empty($_GET['comment_del'])) {
					if ($blog->delComment($_GET['comment_id']) !== false) {
						header('Location: poster.php?post_id='.$post_id.'#comments');
						exit;
					} else {
						$err = $blog->error(1);
					}
				} else {				
					if ($blog->statusComment($_GET['comment_id']) !== false) {
						header('Location: poster.php?post_id='.$post_id.'#c'.$_GET['comment_id']);
						exit;
					} else {
						$err = $blog->error(1);
					}
				}
			} else {
				$err = '<ul><li>Vous n\'avez pas le droit de modifier un commentaire</li></ul>';
			}
		}
		
		# Ajout d'un commentaire
		if (!empty($_POST['add_comment']))
		{
               if ($blog->addComment($post_id,$_POST['com_nom'],
			$_POST['com_email'],$_POST['com_web'],$_POST['com_content']) !== false) {
				header('Location: poster.php?post_id='.$post_id.'#comments');
				exit;
			} else {
				$err = $blog->error(1);
			}
		}
		
		# Changement du status d'un billet
		if (!empty($_GET['cancel']) && $is_editable)
		{
			if ($blog->statusPost($post_id) !== false) {
				header('Location: '.$return_link);
				exit;
			} else {
				$err = $blog->error(1);
			}
		}
		
		# Suppression d'un billet
		if (!empty($_POST['delete']) && $is_editable)
		{
			if ($blog->delPost($post_id) !== false) {
				$msg = 'Billet supprim avec succs';
				header('Location: index.php?msg='.urlencode($msg));
				exit;
			} else {
				$err = $blog->error(1);
			}
		}
	}
}

# Valeurs pour la prvisualisation, la cration ou la modification d'un billet
if (!empty($_POST['preview']) || !empty($_POST['publish']) || !empty($_POST['transform']))
{
	$titre = $_POST['p_titre'];
	$cat_id = $_POST['p_cat'];
	$format = $_POST['p_format'];
	$etat = $_POST['p_etat'];
	$open_comment = $_POST['p_open_comment'];
	$content = $_POST['p_content'];
	$chapo = $_POST['p_chapo'];
	
	if (!empty($post_id))
	{
		$dt_y = (string) sprintf('%04d',$_POST['p_dt_y']);
		$dt_m = (string) sprintf('%02d',$_POST['p_dt_m']);
		$dt_d = (string) sprintf('%02d',$_POST['p_dt_d']);
		$dt_h = (string) sprintf('%02d',$_POST['p_dt_h']);
		$dt_i = (string) sprintf('%02d',$_POST['p_dt_i']);
		$dt_s = (string) sprintf('%02d',$_POST['p_dt_s']);
		
		# Corrections jour & heure
		if ($dt_d > 31 || $dt_d < 1) { $dt_d = '01'; }
		if ($dt_h > 23 || $dt_h < 0) { $dt_h = '00'; }
		if ($dt_i > 59 || $dt_i < 0) { $dt_i = '00'; }
		if ($dt_s > 59 || $dt_s < 0) { $dt_s = '00'; }
		
		$new_date = strtotime($dt_y.'-'.$dt_m.'-'.$dt_d.' '.$dt_h.':'.$dt_i.':'.$dt_s);
	}
	
	if (!empty($_POST['transform'])) {
		$format = 'html';
		$content = $objWiki->transform($content);
		$chapo = $objWiki->transform($chapo);
	}
	
	if ($format == 'wiki') {
		$preview_content = $objWiki->transform($content);
		$preview_chapo = $objWiki->transform($chapo);
	} else {
		$preview_content = $content;
		$preview_chapo = $chapo;
	}
}

# Insertion ou modification d'un billet
if (!empty($_POST['publish']))
{
	# Insertion
	if (empty($post_id))
	{
		if ($blog->addPost($_SESSION['sess_user_id'],$titre,$chapo,$content,
		$cat_id,$format,$etat,$open_comment) !== false) {
			header('Location: '.$return_link);
			exit;
		} else {
			$err = $blog->error(1);
		}
	}
	else
	{
		if ($is_editable) {
			if ($blog->updPost($post_id,$titre,$chapo,$content,$cat_id,
			$format,$etat,$open_comment,$new_date) !== false ) {
				$return_link = 'poster.php?post_id='.$post_id;
				header('Location: '.$return_link);
				exit;
			} else {
				$err = $blog->error(1);
			}
		}
	}
}

# Cration du sous-menu
$mySubMenu->addItem('Retour  la liste des billets',$return_link,'images/ico_retour.png',false);

if (!empty($content) && !empty($post_id) && 
empty($_POST['preview']) && empty($_POST['publish']) && $is_editable)
{
	$mySubMenu->addItem(
		'Validation XHTML',
		array('validpost.php?post_id='.$post_id,'onclick="popup(this.href); return false;"'),
		'images/ico_ok.png',false);
	
	$mySubMenu->addItem(
		'Trackbacks',
		'trackback.php?post_id='.$post_id,
		'images/ico_link.png',false);
}


include dirname(__FILE__).'/inc/_top.php';

if ($err != '')
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.
		$err.'</div>';
}

?>

<h2>Billet</h2>

<?php
if (!empty($content))
{
	if (!empty($_POST['preview'])) {
		$preview_titre = $blog->stripInvalidChars(htmlspecialchars($titre));
	} else {
		$preview_titre = $titre;
	}
	
	echo '<div class="preview">'.
		'<h3>'.$titre.'</h3>'.
		((trim($preview_chapo) != '') ? $preview_chapo.'<hr class="thin" />' : '').
		$preview_content.'</div>';
}
?>

<?php if ($is_editable) : ?>
  <form action="poster.php" method="post" id="formPost">
  <p><span class="nowrap"><label for="p_cat"
  style="display:inline">Catgorie&nbsp;:</label>
  <?php echo php_f_combobox('p_cat',$arry_cat,$cat_id); ?></span>
  
  <span class="nowrap"><label for="p_format"
  style="display:inline">Format&nbsp;:</label>
  <?php
  echo php_f_combobox('p_format',array('HTML'=>'html','Wiki'=>'wiki'),$format);
  ?></span>
  
  <span class="nowrap"><label for="p_etat"
  style="display:inline">tat&nbsp;:</label>
  <?php
  echo php_f_combobox('p_etat',array('En ligne'=>'1','Hors Ligne'=>'0'),$etat);
  ?></span>
  
  <span class="nowrap"><label for="p_open_comment"
  style="display:inline">Commentaires&nbsp;:</label>
  <?php
  echo php_f_combobox('p_open_comment',array('Ouverts'=>'1','Ferms'=>'0'),$open_comment);
  ?></span>
  </p>
  
  <p><label for="p_titre"><strong>Titre : </strong></label>
  <?php echo php_f_textField('p_titre',30,255,$titre,'','style="width:100%"'); ?>
  </p>
  
  <p><label for="p_chapo">Chapo (facultatif) : </label>
  <?php
  echo php_f_textArea('p_chapo',60,4,
  		htmlspecialchars($chapo),'','style="width:100%"');
  ?>
  </p>
  
  <p>
  <span class="bloc-droite"><img src="images/ico_image.png" alt="" />
  <strong><a href="uploadimg.php"
  onclick="popup(this.href+'?mode=popup'); return false;">Insrer
  une image</a></strong></span>
  <label for="p_content"><strong>Billet : </strong></label>
  <?php
  echo php_f_textArea('p_content',60,$_SESSION['sess_user_edit_size'],
  		htmlspecialchars($content),'','style="width:100%"');
  ?>
  </p>
  
  <?php
  if (!empty($post_id))
  {
	echo '<p>Date&nbsp;: '.
		php_f_textField('p_dt_d',2,2,$dt_d).' '.
		php_f_combobox('p_dt_m',$arry_dt_m,$dt_m).' '.
		php_f_textField('p_dt_y',4,4,$dt_y).' '.
		'Heure&nbsp;: '.
		php_f_textField('p_dt_h',2,2,$dt_h).':'.
		php_f_textField('p_dt_i',2,2,$dt_i).':'.
		php_f_textField('p_dt_s',2,2,$dt_s).
		'</p>';
  }
  ?>
  
  <p><input name="preview" type="submit" class="submit" value="visualiser [v]"
  accesskey="v" />&nbsp;
  <input name="publish" type="submit" class="submit" value="enregistrer [s]"
  accesskey="s" />
  <?php
  if (!empty($post_id) && $format == 'wiki')
  {
  	echo '&nbsp;<input name="transform" type="submit" class="submit" '.
	'value="transformer en XHTML" />';
  }
  ?>
  <?php
  if (!empty($post_id))
  {
	echo '&nbsp;<input name="delete" type="submit" class="submit" '.
	'value="supprimer" onclick="return '.
	'window.confirm(\'Etes vous certains de vouloir supprimer ce billet ?\')" />';
	echo php_f_hidden('post_id',$post_id);
  }
  ?></p>
  </form>
  
  <h3><a href="#" onclick="openClose('aidewiki',0); return false"><img
  src="images/moins.png" id="img_aidewiki" alt="montrer/masquer" /></a>
  Rgles de formatage Wiki</h3>
  <div id="aidewiki">
  <?php echo $objWiki->help(); ?>
  </div>
  <script type="text/javascript"><!--
  openClose('aidewiki',-1);
  //--></script>

<?php endif; ?>

<?php if (!empty($post_id)) : ?>
<h2 id="comments">Commentaires</h2>
<?php
if (isset($comments) && !$comments->isEmpty())
{
	echo '<h3>Liste des commentaires</h3>';
	while(!$comments->EOF())
	{
		if ($comments->f('comment_pub')) {
			$com_style = '';
			$com_cancel = 'mettre hors ligne';
		} else {
			$com_style = 'style="color:#999;"';
			$com_cancel = 'mettre en ligne';
		}
		
		echo '<div class="ligne" '.$com_style.' id="c'.$comments->f('comment_id').'">';
		
		echo '<p>'.(($comments->f('comment_trackback')==1) ? '<strong>Trackback</strong><br />' : '').
			'De : '.$comments->f('comment_auteur').'<br />'.
			'Le : '.$comments->getLDate().'  '.$comments->getLTime().'<br />'.
			'Email : '.$comments->f('comment_email').'<br />'.
			'Site : '.(($comments->f('comment_site')) ? 'http://'.$comments->f('comment_site') : '').'<br />'.
			'@IP : '.$comments->f('comment_ip').'</p>'.
			'<div>'.$comments->getContent().'</div>';
		
		if($is_editable)
		{
			echo '<p style="text-align:right">'.
			'<a href="poster.php?post_id='.$post_id.
			'&amp;comment_id='.$comments->f('comment_id').'">'.$com_cancel.'</a>'.
			' - <a href="comment.php?comment_id='.$comments->f('comment_id').'">diter</a>'.
			' - <a href="poster.php?post_id='.$post_id.
			'&amp;comment_id='.$comments->f('comment_id').'&amp;comment_del=1" '.
			'onclick="return window.confirm(\'Etes vous sr ?\');">supprimer</a>'.
			'</p>';
		}
		
		echo '</div>';
		
		$comments->moveNext();
	}
}
?>

<h3>Ajouter un commentaire</h3>
<form action="poster.php" method="post">

<p class="field"><label class="float" for="com_nom"><strong>Nom&nbsp;: </strong></label>
<?php echo php_f_textField('com_nom',30,255,htmlspecialchars($_SESSION['sess_user_cn'])); ?>
</p>
<p class="field"><label class="float" for="com_email">email (facultatif)&nbsp;:</label>
<?php echo php_f_textField('com_email',30,255,htmlspecialchars($_SESSION['sess_user_email'])); ?>
</p>

<p class="field"><label class="float" for="com_web">site web (facultatif)&nbsp;:</label>
<?php echo php_f_textField('com_web',30,255,'http://'); ?>
</p>

<p class="field"><label class="float" for="com_content"><strong>Commentaire&nbsp;: </strong></label>
<?php echo php_f_textArea('com_content',40,6,'',''); ?>
</p>

<p class="field"><input type="submit" class="submit" name="add_comment"
value="ajouter le commentaire" />
<input type="hidden" name="post_id" value="<?php echo $post_id; ?>" /></p>
</form>
<p><strong>Note :</strong> Commentaire au format HTML uniquement.</p>
<?php endif; ?>

<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>