<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****


/**
Script d'installation de la base de donnes
*/

require dirname(__FILE__).'/../conf/config.php';
require dirname(__FILE__).'/../inc/prepend.php';

$res_table = array(
	'connection' => array(false),
	'user' => array(false),
	'categorie' => array(false),
	'post' => array(false),
	'comment' => array(false),
	'ping' => array(false),
	'firstcat' => array(false),
	'firstuser' => array(false),
	'firstpost' => array(false)
);

$error = false;

$con = new Connection($dbuser,$dbpass,$dbhost,$dbbase);

# Tentative de connection
if($err = $con->error()) {
	$res_table['connection'][1] = $err;
	$error = true;
} else {
	$res_table['connection'][0] = true;
}

# Pas de problme, on rcupre la version MySQL
$rsV = $con->select('SELECT VERSION() AS version');
$mysql_version = preg_replace('/-log$/','',$rsV->f(0));

# Pas de problme, table user
if($error !== true) {
	$req="CREATE TABLE ".$dbprefix."user ( ".
		"user_id varchar(32) binary NOT NULL default '', ".
		"user_level int(11) NOT NULL default '0', ".
		"user_pwd varchar(32) binary NOT NULL default '', ".
		"user_nom varchar(255) binary default NULL, ".
		"user_prenom varchar(255) binary default NULL, ".
		"user_pseudo varchar(255) binary default NULL, ".
		"user_email varchar(255) default NULL, ".
		"user_post_format varchar(5) NOT NULL default 'wiki', ".
		"user_edit_size int(11) NOT NULL default '10', ".
		"user_pref_cat int(11) default NULL, ".
		"PRIMARY KEY  (user_id) ".
		") TYPE=MyISAM ";
	
	if($con->execute($req) === false) {
		$res_table['user'][1] = $con->error();
		$error = true;
	} else {
		$res_table['user'][0] = true;
	}
}

# Pas de problme, table categorie
if($error !== true) {
	$req="CREATE TABLE ".$dbprefix."categorie ( ".
		"cat_id int(11) NOT NULL auto_increment, ".
		"cat_libelle varchar(255) NOT NULL, ".
		"cat_desc longtext, ".
		"cat_libelle_url varchar(255) NOT NULL default '', ".
		"PRIMARY KEY  (cat_id), ".
		"UNIQUE KEY cat_libelle_url (cat_libelle_url), ".
		"UNIQUE KEY cat_libelle (cat_libelle) ".
		") TYPE=MyISAM ";
	if($con->execute($req) === false) {
		$res_table['categorie'][1] = $con->error();
		$error = true;
	} else {
		$res_table['categorie'][0] = true;
	}
}

# Pas de problme, table post
if($error !== true) {
	$req="CREATE TABLE ".$dbprefix."post ( ".
		"post_id int(11) NOT NULL auto_increment, ".
		"user_id varchar(32) binary NOT NULL default '', ".
		"cat_id int(11) default NULL, ".
		"post_dt datetime default NULL, ".
		"post_creadt datetime default NULL, ".
		"post_upddt datetime default NULL, ".
		"post_titre varchar(255) default NULL, ".
		"post_chapo longtext, ".
		"post_chapo_wiki longtext, ".
		"post_content longtext, ".
		"post_content_wiki longtext, ".
		"post_pub int(1) NOT NULL default '0', ".
		"post_open_comment int(1) NOT NULL default '0', ".
		"nb_comment int(11) NOT NULL default '0', ".
		"PRIMARY KEY  (post_id) ";
	
	# Si la version de MySQL est >= 3.23.23 on ajoute ces cls
	if (version_compare($mysql_version,'3.23.23','>='))
	{
		$req.=", FULLTEXT KEY full_post_titre (post_titre), ".
			"FULLTEXT KEY full_post_content (post_content), ".
			"FULLTEXT KEY full_post_chapo (post_chapo) ";
	}
	
	$req.=") TYPE=MyISAM ";
	
	if($con->execute($req) === false) {
		$res_table['post'][1] = $con->error();
		$error = true;
	} else {
		$res_table['post'][0] = true;
	}
}

# Pas de problme, table comment
if($error !== true) {
	$req="CREATE TABLE ".$dbprefix."comment ( ".
		"comment_id int(11) NOT NULL auto_increment, ".
		"post_id int(11) NOT NULL default '0', ".
		"comment_dt datetime default NULL, ".
		"comment_upddt datetime default NULL, ".
		"comment_auteur varchar(255) default NULL, ".
		"comment_email varchar(255) default NULL, ".
		"comment_site varchar(255) default NULL, ".
		"comment_content longtext, ".
		"comment_ip varchar(15) default NULL, ".
		"comment_pub int(1) default '0', ".
		"comment_trackback int(1) NOT NULL default '0', ".
		"PRIMARY KEY  (comment_id) ".
		") TYPE=MyISAM ";
	if($con->execute($req) === false) {
		$res_table['comment'][1] = $con->error();
		$error = true;
	} else {
		$res_table['comment'][0] = true;
	}
}

# Pas de problme, table ping
if ($error !== true) {
	$req="CREATE TABLE ".$dbprefix."ping (".
		"ping_id int(11) NOT NULL auto_increment, ".
		"post_id int(11) NOT NULL default '0', ".
		"ping_url varchar(255) NOT NULL default '0', ".
		"ping_dt datetime default NULL, ".
		"PRIMARY KEY  (ping_id) ".
		") TYPE=MyISAM ";
	if($con->execute($req) === false) {
		$res_table['ping'][1] = $con->error();
		$error = true;
	} else {
		$res_table['ping'][0] = true;
	}
}

# Pas de problme, cration de la catgorie vide
if($error !== true) {
	$req="INSERT INTO ".$dbprefix."categorie ".
		"(cat_id,cat_libelle,cat_libelle_url) VALUES ".
		"(1,'Gnral','General') ";
		
	if($con->execute($req) === false) {
		$res_table['firstcat'][1] = $con->error();
		$error = true;
	} else {
		$res_table['firstcat'][0] = true;
	}
}

# Pas de problme, cration de l'administrateur
if($error !== true) {
	$req="INSERT INTO ".$dbprefix."user ".
		"(user_id,user_nom,user_level,user_pwd,user_pref_cat) VALUES ".
		"('admin','Administrateur',9,'".md5('admin')."',1) ";
		
	if($con->execute($req) === false) {
		$res_table['firstuser'][1] = $con->error();
		$error = true;
	} else {
		$res_table['firstuser'][0] = true;
	}
}

# Pas de problme, cration du premier billet
if($error !== true) {
	$post = 
	$req="INSERT INTO ".$dbprefix."post VALUES (1,'admin',1,SYSDATE(),".
		"SYSDATE(),SYSDATE(),".
		"'Mon nouveau weblog !','','','<p>Ceci est le premier billet, modifiez le ".
		"ou supprimez le.</p>','',1,1,0) ";
	
	if($con->execute($req) === false) {
		$res_table['firstpost'][1] = $con->error();
		$error = true;
	} else {
		$res_table['firstpost'][0] = true;
	}
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>DotClear - Installation</title>
<style type="text/css">
<!-- 
body {
	background : #fcfcfc url("images/fond.jpg");
	font-family : Verdana,Arial,Helevetica,sans-serif;
	color : #000;
	font-size : 0.8em;
	margin : 2em 8% 2em 8%;
}

a { color : #039; }

html*a:hover, html*a:focus { text-decoration : none; }

#main { background:#fff;color:#000;border:2px solid #000;padding:1em; }

.install { border-collapse : collapse; }

.install td { padding : 0.5em 1em 0.2em 0; }

.install .t { white-space: nowrap; }

.important { font-weight: bold; color: #f00; }
-->
</style>
</head>

<body>

<div id="main">
<h1>Installation de DotClear</h1>

<?php
if($error === true) {
	echo '<p class="important">Des erreurs sont survenues.</p>';
}

function check_install($item)
{
	global $res_table;
	
	$err = ' ';
	
	$on = 'images/check_on.png';
	$off = 'images/check_off.png';
	
	
	if($res_table[$item][0] === true) {
		echo '<td valign="top"><img src="'.$on.'" alt="OK" /></td>';
	} else {
		echo '<td valign="top"><img src="'.$off.'" alt="ERREUR" /></td>';
		$err = (!empty($res_table[$item][1])) ? $res_table[$item][1] : ' ';
	}
	
	echo '<td>'.$err.'</td>';
}
?>

<table summary="Installation" class="install">
<tr>
 <td valign="top" class="t">Connexion  la base de donne</td>
 <?php check_install('connection'); ?>
</tr>
<tr>
 <td valign="top" class="t">Cration de la table <strong><?php echo $dbprefix; ?>user</strong></td>
 <?php check_install('user'); ?>
</tr>
<tr>
 <td valign="top" class="t">Cration de la table <strong><?php echo $dbprefix; ?>categorie</strong></td>
 <?php check_install('categorie'); ?>
</tr>
<tr>
 <td valign="top" class="t">Cration de la table <strong><?php echo $dbprefix; ?>post</strong></td>
 <?php check_install('post'); ?>
</tr>
<tr>
 <td valign="top" class="t">Cration de la table <strong><?php echo $dbprefix; ?>comment</strong></td>
 <?php check_install('comment'); ?>
</tr>
<tr>
 <td valign="top" class="t">Cration de la table <strong><?php echo $dbprefix; ?>ping</strong></td>
 <?php check_install('ping'); ?>
</tr>
<tr>
 <td valign="top" class="t">Cration de la premire catgorie</td>
 <?php check_install('firstcat'); ?>
</tr>
<tr>
 <td valign="top" class="t">Cration du premier utilisateur</td>
 <?php check_install('firstuser'); ?>
</tr>
<tr>
 <td valign="top" class="t">Cration du premier billet</td>
 <?php check_install('firstpost'); ?>
</tr>
</table>

<?php
if($error === false) {
	echo '<p><strong>Flicitations!</strong></p>';
	echo '<p>L\'installation de DotClear est maintenant termin vous pouvez '.
	'vous connecter  <a href="index.php">l\'interface d\'administration de '.
	'votre weblog</a> en utilisant le login <strong>admin</strong> et le mot de '.
	'passe <strong>admin</strong>.</p>';
	echo '<p class="important">N\'oubliez pas de changer votre mot de passe&nbsp;!</p>';
} ?>

</div>
<p style="text-align:right; font-size:0.8em; margin: 0;">dotclear blog</p>

</body>
</html>