<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

if (!empty($_GET['logout'])) {
	$_SESSION = array();
}

auth(1);
include dirname(__FILE__).'/inc/connexion.php';

$q = (!empty($_GET['q'])) ? $_GET['q'] : '';

# Sous menu
$mySubMenu->addItem(
	'<strong>Nouveau billet</strong>','poster.php','images/ico_edit.png',false);
$mySubMenu->addItem(
	'Gestion des images','uploadimg.php','images/ico_image.png',false);


include dirname(__FILE__).'/inc/_top.php';
?>

<h2>Liste des billets</h2>

<?php
# Les catgories du blog
$cat_id = (!empty($_GET['cat_id'])) ? $_GET['cat_id'] : '';

$rsCat = $blog->getCat();

$arry_cat['&nbsp;'] = NULL;
while (!$rsCat->EOF())
{
	$arry_cat[$rsCat->f('cat_libelle').
			' ['.$rsCat->f('nb_post').']'] = $rsCat->f('cat_id');
	$rsCat->moveNext();
}

# Tableau des mois du blog
$arry_months = array();
foreach ($blog->getAllDates('m','','','',$cat_id) as $k => $v) {
	$arry_months[strftime('%B %Y',$k)] = date('Ym',$k);
}

# Determiner $y et $m les dates de la page
if (!empty($_GET['m']) && in_array($_GET['m'],$arry_months)) {
	$m = substr($_GET['m'],4);
	$y = substr($_GET['m'],0,4);
} else {
	$my_dt = $blog->getEarlierDate($cat_id);
	$my_dt = (empty($my_dt)) ? time() : strtotime($my_dt);
	$m = date('m',$my_dt);
	$y = date('Y',$my_dt); 
}

# Formulaire avec les mois et les catgories
echo '<form action="index.php"><p>';
echo '<label for="m" style="display:inline;"><strong>Mois : </strong></label>';
echo php_f_comboBox('m',$arry_months,$y.$m);
echo ' <label for="cat_id" style="display:inline;"><strong>Catgorie : </strong></label>';
echo php_f_comboBox('cat_id',$arry_cat,$cat_id);
echo ' <input class="submit" type="submit" value="ok" />';
echo '</p></form>';

# Affichage des mois suivants et prcdents
if(!empty($arry_months))
{
	$m_invert = array_flip($arry_months);
	$m_next = getNextPrev($m_invert,$y.$m,'prev');
	$m_prev = getNextPrev($m_invert,$y.$m,'next');
	echo '<p>';
	if($m_next) {
		echo '<a href="index.php?m='.key($m_next).'&amp;cat_id='.$cat_id.'">&#171; '.
		current($m_next).'</a> - ';
	}
	
	echo '<strong>'.$m_invert[$y.$m].'</strong>';
	if($m_prev) {
		echo ' - <a href="index.php?m='.key($m_prev).'&amp;cat_id='.$cat_id.'">'.
		current($m_prev).' &#187;</a>';
	}
	echo '</p>';
}

# Les billets
if ($q == '') {
	$posts = $blog->getPostByDate($y,$m,'',$cat_id,'DESC');
} else {
	$posts = $blog->searchPost($q);
}

# Pour voir ou cacher tout les billets
if ($posts->isEmpty())
{
	echo '<p>Aucun billet.</p>';
}
else
{
	echo '<script type="text/javascript">'."\n".
		"<!--\n".
		"var js_post_ids = new Array('".implode("','",$posts->getIDs('content'))."')\n".
		"//-->\n".
		"</script>\n";
	
	echo '<p class="small"><a href="#" onclick="mOpenClose(js_post_ids,1); return false;">tout montrer</a>'.
	' - <a href="#" onclick="mOpenClose(js_post_ids,-1); return false;">tout cacher</a></p>';
	
	while(!$posts->EOF())
	{
		if ($posts->f('post_pub') == 0) {
			$post_cancel = 'mettre en ligne';
			$post_class = 'cancel';
			$post_img = '<img src="images/check_off.png" '.
					'alt="Ce billet est hors ligne" class="status" />';
		} else {
			$post_cancel = 'mettre hors ligne';
			$post_class = 'published';
			$post_img = '<img src="images/check_on.png" '.
					'alt="Ce billet est en ligne" class="status" />';
		}
		
		$nb_comments = $posts->getNbComments();
		
		# Liens pour l'dition et mise hors ligne accesibles uniquement au
		# propritaire du billet ou  un admin
		if ($_SESSION['sess_user_level'] == 9 || $posts->f('user_id') == $_SESSION['sess_user_id']) {
			$edit_links = '[ <strong><a href="poster.php?post_id='.$posts->f('post_id').'">'.
			'diter</a></strong> | '.
			'<a href="poster.php?post_id='.$posts->f('post_id').'&amp;cancel=1">'.
			$post_cancel.'</a> ] ';
		} else {
			$edit_links = '[ <strong><a href="poster.php?post_id='.$posts->f('post_id').'">'.
			'consulter</a></strong> ] ';
		}
		
		echo '<div class="ligne '.$post_class.'" id="p'.$posts->f('post_id').'">'.
			'<p><a href="#" onclick="openClose(\'content'.$posts->f('post_id').'\',0); return false;">'.
			'<img src="images/plus.png" id="img_content'.$posts->f('post_id').'" '.
			'alt="montrer/masquer" /></a> '.
			'<strong>'.date('d/m/Y @ H:i:s',$posts->getTS()).'</strong>'.
			' '.$edit_links;
		
		echo '<a href="poster.php?post_id='.$posts->f('post_id').'#comments">';
		echo ($nb_comments > 1) ? $nb_comments.' commentaires' : $nb_comments.' commentaire';
		echo '</a>';
		
		echo $post_img.' <br /><span class="post-info"><strong>'.$posts->f('post_titre').'</strong> - '.
			'par <strong>'.$posts->getUserCN().'</strong> - '.
			' dans <strong>'.$posts->f('cat_libelle').'</strong></span>'.
			'</p>'.
			'<div id="content'.$posts->f('post_id').'" style="display:none;">'.
			(($posts->f('post_chapo')!='') ? $posts->f('post_chapo').'<hr class="thin" />' : '').
			$posts->f('post_content').'</div>'.
			'</div>';
		
		$posts->moveNext();
	}
}
?>

<form action="index.php"><p>
<label for="q" style="display:inline;">Chercher : </label>
<?php echo php_f_textField('q',20,'',$q); ?>
 <input class="submit" type="submit" value="ok" />
</p></form>

<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>

