<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';
require dirname(__FILE__).'/../inc/class.lum.php';

auth(1);
include dirname(__FILE__).'/inc/connexion.php';

include dirname(__FILE__).'/inc/_top.php';
?>


<h2>Commentaires</h2>

<p>Liste des commentaires classs par date dcroissante.</p>

<?php
$nb_per_page = 30;
$nb_comments = $blog->getNbComments();

$max_pages = ceil($nb_comments/$nb_per_page);
$env = (!empty($_GET['env']) && $_GET['env'] <= $max_pages) ? $_GET['env'] : 1;

$comments = $blog->getComments('','DESC',(($env-1)*$nb_per_page).','.$nb_per_page);

# Pour voir ou cacher les commentaires
$js_openCloseAll = '';
if (!$comments->isEmpty())
{
	echo '<script type="text/javascript">'."\n".
		"<!--\n".
		"js_comments_ids = new Array('".implode("','",$comments->getIDs('comment'))."')\n".
		"//-->\n".
		"</script>\n";
	
	$js_openCloseAll =  '<p class="small">'.
		'<a href="#" onclick="mOpenClose(js_comments_ids,1)">tout montrer</a>'.
		' - <a href="#" onclick="mOpenClose(js_comments_ids,-1)">tout cacher</a></p>';
}

$arryData = $comments->getData();

# Ligne pour afficher un commentaire
function ligne_comment($data,$i)
{
	$comment_id = $data['comment_id'];
	$comment_dt = $data['comment_dt'];
	$comment_auteur = $data['comment_auteur'];
	$comment_email = $data['comment_email'];
	$comment_site = $data['comment_site'];
	$comment_content = $data['comment_content'];
	$comment_pub = $data['comment_pub'];
	$comment_ip = $data['comment_ip'];
	$comment_trackback = $data['comment_trackback'];
	$post_titre = $data['post_titre'];
	$post_id = $data['post_id'];
	$comment_date = date('d/m/Y H:i',strtotime($comment_dt));
	
	if($comment_pub)
	{
		$com_style = '';
		$com_img = '<img src="images/check_on.png" '.
				'alt="Ce commentaire est en ligne" class="status" /> ';
	}
	else
	{
		$com_style = ' cancel';
		$com_img = '<img src="images/check_off.png" '.
				'alt="Ce commentaire a t annul" class="status" /> ';
	}
	
	$str_tb = ($comment_trackback == 1) ? ' - <strong>trackback</strong>' : '';
	
	$res = '<div class="ligne'.$com_style.'">'.
		'<p><a href="#" onclick="openClose(\'comment'.$comment_id.'\',0); return false;">'.
		'<img src="images/plus.png" id="img_comment'.$comment_id.'" '.
		'alt="montrer/masquer" /></a> '.
		'<a href="poster.php?post_id='.$post_id.'#c'.$comment_id.'">'.
		$post_titre.'</a>'.$str_tb.'<br />'.$com_img.
		$comment_date.' - '.$comment_auteur.'</p>';
	
	$res .= '<div id="comment'.$comment_id.'" class="comment" style="display:none;">'.
		$comment_content.'</div>';
	
	$res .= '</div>';
	
	return $res;
}

// Afichage
$objLum = new lum($env,'ligne_comment',$arryData,$nb_comments,$nb_per_page);

$objLum->htmlHeader = '';
$objLum->htmlLineStart = '';
$objLum->htmlColStart = '';
$objLum->htmlColEnd = '';
$objLum->htmlLineEnd = '';
$objLum->htmlFooter = '';

$objLum->htmlLinksStart = '<p>';
$objLum->htmlLinksEnd = '</p>';

$objLum->htmlCurPgStart = '<strong>';
$objLum->htmlCurPgEnd = '</strong>';

$objLum->htmlPrev = '&lt;page prc.';
$objLum->htmlNext = 'page suiv.&gt;';
$objLum->htmlPrevGrp = '...';
$objLum->htmlNextGrp = '...';

$objLum->htmlEmpty = '<p><strong>Aucun commentaire pour le moment</strong></p>';

echo $objLum->drawLinks();
echo $js_openCloseAll;
echo $objLum->drawPage();
echo $objLum->drawLinks();
?>

<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>
