<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

auth(1);
include dirname(__FILE__).'/inc/connexion.php';


$err = '';
$is_editable = false;
$comment_id = '';
$comment_dt = '';
$comment_auteur = '';
$comment_email = '';
$comment_site = '';
$comment_content = '';
$comment_pub = '';
$comment_ip = '';
$post_titre = '';
$post_id = '';
$user_id = '';

if (!empty($_REQUEST['comment_id']))
{
	$comment = $blog->getComment($_REQUEST['comment_id']);
	
	if ($comment->isEmpty()) {
		$err = '<ul><li>Pas de commentaire.</li></ul>';
	} else {
		$comment_id = $comment->f('comment_id');
		$comment_ldate = $comment->getLDate().'  '.$comment->getLTime();
		$comment_auteur = $comment->f('comment_auteur');
		$comment_email = $comment->f('comment_email');
		$comment_site = $comment->f('comment_site');
		$comment_content = $comment->f('comment_content');
		$comment_pub = (integer) $comment->f('comment_pub');
		$comment_ip = $comment->f('comment_ip');
		$post_titre = $comment->f('post_titre');
		$post_id = $comment->f('post_id');
		
		if ($comment->f('user_id') == $_SESSION['sess_user_id'] || $_SESSION['sess_user_level'] == 9)
		{
			$is_editable = true;
		}
	}
}

# On arrte tout si le commentaire est pas ditable
if (!$is_editable)
{
	$err = '<ul><li>Vous n\'avez pas le droit de modifier ce commentaire.</li></ul>';
}

# Modification du commentaire
if (!empty($_POST['update']) && $is_editable)
{
	$comment_auteur = $_POST['c_auteur'];
	$comment_email = $_POST['c_email'];
	$comment_site = preg_replace('|^http://|','',$_POST['c_site']);
	$comment_content = $_POST['c_content'];
	$comment_pub = $_POST['c_pub'];
	
	if ($blog->updComment($comment_id,$comment_auteur,$comment_email,
	$comment_site,$comment_content,$comment_pub) !== false) {
		header('Location: poster.php?post_id='.$post_id.'#c'.$comment_id);
		exit;
	} else {
		$err = $blog->error(1);
	}	
}

# Suppression du commentaire
if (!empty($_POST['delete']) && $is_editable)
{
	if ($blog->delComment($comment_id) !== false) {
		header('Location: poster.php?post_id='.$post_id.'#comments');
		exit;
	} else {
		$err = $blog->error(1);
	}
}

include dirname(__FILE__).'/inc/_top.php';

if ($err != '')
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.
		$err.'</div>';
}

if ($is_editable)
{
?>

<h2>dition d'un commentaire</h2>

<p><strong>Billet :</strong>
<a href="poster.php?post_id=<?php echo $post_id; ?>"><?php echo $post_titre; ?></a></p>

<form action="comment.php" method="post">
<p class="field"><label class="float" for="c_auteur">auteur&nbsp;:</label>
<?php echo php_f_textField('c_auteur',30,255,htmlspecialchars($comment_auteur)); ?></p>

<p class="field"><label class="float" for="c_email">email&nbsp;:</label>
<?php echo php_f_textField('c_email',30,255,htmlspecialchars($comment_email)); ?></p>

<p class="field"><label class="float" for="c_site">site Web&nbsp;:</label>
<?php echo php_f_textField('c_site',30,255,'http://'.htmlspecialchars($comment_site)); ?></p>

<p class="field"><span class="label">adresse IP&nbsp;:</span>
<span><?php echo $comment_ip; ?></span></p>

<p class="field"><span class="label">date&nbsp;:</span>
<span><?php echo $comment_ldate; ?></span></p>

<p class="field"><label class="float" for="">tat&nbsp;:</label>
<?php echo php_f_combobox('c_pub',array('En ligne'=>'1','Hors Ligne'=>'0'),$comment_pub); ?>

<p class="field"><label class="float" for="c_content">Commentaire&nbsp;:</label>
<?php echo php_f_textArea('c_content',40,6,htmlspecialchars($comment_content)); ?>
</p>

<p class="field"><input type="submit" class="submit" name="update" value="mettre  jour" />&nbsp;
<input type="submit" class="submit" name="delete" value="supprimer"
onclick="return window.confirm('Etes vous sr de vouloir supprimer ce commentaire ?')" />
<input type="hidden" name="comment_id" id="comment_id"
value="<?php echo $comment_id; ?>" /></p>
</form>

<?php } ?>

<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>
