<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

auth(5);
include dirname(__FILE__).'/inc/connexion.php';

$err = '';
$cat_libelle = '';
$cat_desc = '';

$str_submit = (!empty($_REQUEST['cat_id'])) ? 'Modifier' : 'Crer';

# Edition d'une catgorie
if (!empty($_REQUEST['cat_id']))
{
	$rsCat = $blog->getCat($_REQUEST['cat_id']);
	
	$cat_libelle = $rsCat->field('cat_libelle');
	$cat_desc = $rsCat->field('cat_desc');
	$cat_id = $rsCat->field('cat_id');
	
	# Suppression
	if (!empty($_GET['del']))
	{
		if ($blog->delCat($cat_id) !== false) {
			$msg = 'Catgorie supprime';
			header('Location: cat_list.php?msg='.rawurlencode($msg));
			exit;
		} else {
			$msg = 'Impossible de supprimer la catgorie';
			header('Location: cat_list.php?msg='.rawurlencode($msg));
		}
	}
	
	# Modification
	if (!empty($_POST['submit']) && $cat_id)
	{
		$cat_libelle = $_POST['cat_libelle'];
		$cat_desc = $_POST['cat_desc'];
		
		if ($blog->updCat($cat_id,$cat_libelle,$cat_desc) !== false) {
			$msg = 'Catgorie mise  jour';
			header('Location: cat_list.php?msg='.rawurlencode($msg));
			exit;
		} else {
			$err = $blog->error(1);
		}
	}
}
# Ajout d'une catgorie
elseif (!empty($_POST['submit']))
{
	$cat_libelle = $_POST['cat_libelle'];
	$cat_desc = $_POST['cat_desc'];
	
	if ($blog->addCat($cat_libelle,$cat_desc) !== false) {
			$msg = 'Catgorie cre avec succs';
			header('Location: cat_list.php?msg='.rawurlencode($msg));
			exit;
		} else {
			$err = $blog->error(1);
		}
}

include dirname(__FILE__).'/inc/_top.php';

if ($err != '')
{
	echo '<div class="erreur"><p><strong>Erreur(s) :</strong></p>'.
		$err.'</div>';
}
?>
<p><strong><a href="cat_list.php">retour</a></strong></p>

<h2>Catgorie</h2>

<form action="categorie.php" method="post">
<p><label for="cat_libelle"><strong>Titre : </strong></label>
<?php echo php_f_textField('cat_libelle',40,255,$cat_libelle,'','style="width:100%"'); ?>
</p>

<p><label for="cat_desc">Description (facultatif) : </label>
<?php echo php_f_textArea('cat_desc',60,4,htmlspecialchars($cat_desc),'','style="width:100%"'); ?>
</p>

<p><input class="submit" type="submit" name="submit" value="<?php echo $str_submit; ?>" />
<?php
if (!empty($cat_id)) {
	echo php_f_hidden('cat_id',$cat_id);
}
?>
</p>
</form>

<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>
