<?php
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is DotClear Weblog.
#
# The Initial Developer of the Original Code is
# Olivier Meunier.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

require dirname(__FILE__).'/inc/prepend.php';

auth(5);
include dirname(__FILE__).'/inc/connexion.php';

$mySubMenu->addItem('<strong>Nouvelle catgorie</strong>','categorie.php','images/ico_new.png',false);

include dirname(__FILE__).'/inc/_top.php';
?>

<h2>Liste des catgories</h2>

<?php
$rsCat = $blog->getCat();

if ($rsCat->isEmpty())
{
	echo '<p>Aucune catgorie pour le moment.</p>';
}
else
{
	while(!$rsCat->EOF())
	{
		$cat_id = $rsCat->field('cat_id');
		$cat_libelle = $rsCat->field('cat_libelle');
		$cat_nb_post = (integer) $rsCat->field('nb_post');
		
		echo '<div class="ligne">';
		echo '<p><strong>'.$cat_libelle.'</strong> (#'.$cat_id.') [ '.
			'<strong><a href="categorie.php?cat_id='.$cat_id.'">diter</a></strong> - ';
		
		
		if ($cat_nb_post > 0)
		{
			echo '<a href="index.php?cat_id='.$cat_id.'">'.$cat_nb_post.' billet';
			echo ($cat_nb_post > 1) ? 's' : '';
			echo '</a>';
		}
		else
		{
			echo '<a href="categorie.php?cat_id='.$cat_id.'&amp;del=1" '.
			' onclick="return window.confirm(\'Etes vous sr de vouloir '.
			'supprimer cette catgorie ?\')">'.
			'supprimer</a>';
		}
		echo ' ]</p></div>';
		
		$rsCat->moveNext();
	}
}
?>

<?php include dirname(__FILE__).'/inc/_bottom.php'; ?>
